/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.transactions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.wamblee.general.ValueHolder;
import org.wamblee.test.transactions.SimpleTransactionManager;
import org.wamblee.test.transactions.TransactionResource;
import org.wamblee.test.transactions.UserTransactionCallback;
import org.wamblee.test.transactions.UserTransactionFactory;

public class SimpleTransactionManagerTest {
    private List<UserTransactionCallback> callbacks;
    private UserTransactionFactory factory;
    private SimpleTransactionManager manager;

    @Before
    public void setUp() {
        this.callbacks = new ArrayList<UserTransactionCallback>();
        this.factory = (UserTransactionFactory)Mockito.mock(UserTransactionFactory.class);
        Mockito.when((Object)this.factory.create((UserTransactionCallback)Mockito.any(UserTransactionCallback.class), (List)Mockito.any(List.class))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock aInvocation) throws Throwable {
                SimpleTransactionManagerTest.this.callbacks.add((UserTransactionCallback)aInvocation.getArguments()[0]);
                return Mockito.mock(UserTransaction.class);
            }
        });
        this.manager = new SimpleTransactionManager(this.factory);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testTransactionsAreThreadSpecific() throws Exception {
        this.manager.getTransaction().getStatus();
        UserTransaction transaction = this.manager.getThreadSpecificTransaction();
        Assert.assertNotNull((Object)transaction);
        Assert.assertSame((Object)transaction, (Object)this.manager.getThreadSpecificTransaction());
        final ValueHolder transaction2 = new ValueHolder();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SimpleTransactionManagerTest.this.manager.getTransaction().getStatus();
                    transaction2.setValue((Object)SimpleTransactionManagerTest.this.manager.getThreadSpecificTransaction());
                }
                catch (SystemException e) {
                    Assert.fail((String)"exception ");
                }
            }
        });
        t.start();
        t.join();
        Assert.assertNotNull((Object)transaction);
        Assert.assertNotNull((Object)transaction2.getValue());
        Assert.assertTrue((transaction != transaction2.getValue() ? 1 : 0) != 0);
    }

    @Test
    public void testTransactionLifeCycle() throws Exception {
        this.manager.getTransaction().getStatus();
        UserTransaction transaction = this.manager.getThreadSpecificTransaction();
        Assert.assertNotNull((Object)transaction);
        Assert.assertEquals((int)1, (int)this.callbacks.size());
        this.callbacks.get(0).transactionFinished();
        this.manager.getTransaction().getStatus();
        UserTransaction transaction2 = this.manager.getThreadSpecificTransaction();
        Assert.assertNotNull((Object)transaction2);
        assert (transaction != transaction2);
    }

    @Test
    public void testVerifyResourcesArePassedToFactory() throws Exception {
        final ValueHolder actual = new ValueHolder();
        Mockito.when((Object)this.factory.create((UserTransactionCallback)Mockito.any(UserTransactionCallback.class), (List)Mockito.any())).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock aInvocation) throws Throwable {
                Object[] value = ((List)aInvocation.getArguments()[1]).toArray();
                actual.setValue((Object)value);
                return Mockito.mock(UserTransaction.class);
            }
        });
        TransactionResource resource1 = (TransactionResource)Mockito.mock(TransactionResource.class);
        TransactionResource resource2 = (TransactionResource)Mockito.mock(TransactionResource.class);
        this.manager.addResource(resource1);
        this.manager.addResource(resource2);
        this.manager.getTransaction().getStatus();
        Object[] expected = new Object[]{resource1, resource2};
        Assert.assertTrue((boolean)Arrays.equals(expected, (Object[])actual.getValue()));
    }

    @Test
    public void testTwoTransactions() throws Exception {
        UserTransaction transaction = this.manager.getTransaction();
        transaction.begin();
        transaction.commit();
        transaction.begin();
        transaction.commit();
    }
}

