/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.inject;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wamblee.reflection.Accessor;
import org.wamblee.reflection.AnnotationUtils;

public class Binding<T> {
    private Class<T> clazz;
    private Class<? extends Annotation> annotation;
    private Object value;
    private Map<Class, List<Accessor>> accessorCache;

    public Binding(Class<T> aClass, Class<? extends Annotation> aAnnotation, Object aValue) {
        this.clazz = aClass;
        this.annotation = aAnnotation;
        this.value = aValue;
        this.accessorCache = new ConcurrentHashMap<Class, List<Accessor>>();
    }

    public void inject(Object aObject) {
        List<Accessor> accessors = this.getAccessors(aObject);
        for (Accessor accessor : accessors) {
            if (!this.clazz.isAssignableFrom(accessor.getType())) continue;
            accessor.set(aObject, this.value);
        }
    }

    private List<Accessor> getAccessors(Object aObject) {
        Class<?> type = aObject.getClass();
        List accessors = this.accessorCache.get(type);
        if (accessors == null) {
            accessors = AnnotationUtils.analyse(aObject.getClass(), this.annotation);
            this.accessorCache.put(type, accessors);
        }
        return accessors;
    }
}

