/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.inject;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.wamblee.inject.Injector;
import org.wamblee.reflection.ObjectTraversal;
import org.wamblee.test.inject.Binding;

public class JavaEETestInjector
implements Injector {
    private List<Binding> bindings;
    private Injector delegate;

    public JavaEETestInjector(Class aClass, List<Binding> aBindings, Injector aDelegate) {
        this.bindings = aBindings;
        this.delegate = aDelegate;
    }

    public void inject(Object aComponent) {
        this.delegate.inject(aComponent);
        ObjectTraversal traversal = new ObjectTraversal((ObjectTraversal.ObjectVisitor)new InjectionVisitor());
        traversal.accept(aComponent);
    }

    private void performTestInjections(Object aComponent) {
        for (Binding binding : this.bindings) {
            binding.inject(aComponent);
        }
    }

    private class InjectionVisitor
    implements ObjectTraversal.ObjectVisitor {
        private InjectionVisitor() {
        }

        public boolean mustVisit(Class aClass) {
            return !EntityManager.class.isAssignableFrom(aClass);
        }

        public boolean mustVisit(Field aField) {
            return aField.getAnnotations().length > 0;
        }

        public boolean mustVisit(Method aMethod) {
            return false;
        }

        public boolean visitArray(Object aArray) {
            return true;
        }

        public boolean visitList(List aObject) {
            return true;
        }

        public boolean visitMap(Map aObject) {
            return true;
        }

        public boolean visitPlainObject(Object aObject) {
            JavaEETestInjector.this.performTestInjections(aObject);
            return true;
        }

        public boolean visitSet(Set aSet) {
            return true;
        }
    }
}

