/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.persistence;

import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.derby.drda.NetworkServerControl;
import org.wamblee.io.FileSystemUtils;
import org.wamblee.test.persistence.AbstractDatabase;

public class DerbyDatabase
extends AbstractDatabase {
    private static final Logger LOGGER = Logger.getLogger(DerbyDatabase.class.getName());
    private static final String USERNAME = "sa";
    private static final String PASSWORD = "123";
    private static final int POLL_INTERVAL = 100;
    private static final int MAX_WAIT_TIME = 10000;
    private static final String DATABASE_NAME = "testdb";
    private static final String DATABASE_PATH = "target/db/persistence/derby";
    private static final String SYSTEM_PATH_PROPERTY = "derby.system.home";
    private boolean inmemory;

    public DerbyDatabase() {
        this.inmemory = true;
    }

    public DerbyDatabase(boolean aInMemoryFlag) {
        this.inmemory = aInMemoryFlag;
    }

    @Override
    public void doStart() {
        try {
            System.setProperty("derby.stream.error.file", "target/derby.log");
            this.cleanPersistentStorage();
            if (!this.inmemory) {
                Properties lProperties = System.getProperties();
                lProperties.put(SYSTEM_PATH_PROPERTY, DATABASE_PATH);
            }
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            this.runDatabase();
            this.waitUntilStartedOrStopped(true);
            Connection lConnection = this.createConnection();
            lConnection.close();
            LOGGER.info("Database started: \n    URL = " + this.getExternalJdbcUrl() + "\n    user = " + this.getUsername() + "\n    password = " + this.getPassword());
            this.createDataSource();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (DerbyDatabase.this.isStarted()) {
                        LOGGER.warning("Shutting down db");
                        DerbyDatabase.this.stop();
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Problem starting database", e);
        }
    }

    private void waitUntilStartedOrStopped(boolean aStarted) throws InterruptedException {
        long lWaited = 0L;
        while (aStarted != this.isStarted()) {
            Thread.sleep(100L);
            if ((lWaited += 100L) <= 10000L) continue;
            Assert.fail((String)"Derby database did not start within 10000ms");
        }
    }

    private boolean isStarted() {
        try {
            this.getControl().ping();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private NetworkServerControl getControl() throws Exception {
        return new NetworkServerControl();
    }

    private void runDatabase() {
        try {
            this.getControl().start(new PrintWriter(System.out));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getJdbcUrl() {
        return this.getBaseJdbcUrl() + ";create=true;retrieveMessagesFromServerOnGetMessage=true;";
    }

    private String getBaseJdbcUrl() {
        return (this.inmemory ? "jdbc:derby:memory:" : "jdbc:derby:") + DATABASE_NAME;
    }

    @Override
    public String getExternalJdbcUrl() {
        return "jdbc:derby://localhost:1527/" + (this.inmemory ? "memory:" : "") + DATABASE_NAME;
    }

    private void shutdownDerby() {
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            throw new RuntimeException("Derby did not shutdown, should always throw exception at shutdown");
        }
        catch (Exception e) {
            LOGGER.info("Derby has been shut down.");
            return;
        }
    }

    @Override
    public String getUsername() {
        return USERNAME;
    }

    @Override
    public String getPassword() {
        return PASSWORD;
    }

    public Connection createConnection() throws SQLException {
        Connection c = DriverManager.getConnection(this.getJdbcUrl(), this.getUsername(), this.getPassword());
        return c;
    }

    @Override
    public void doStop() {
        try {
            this.getControl().shutdown();
            this.waitUntilStartedOrStopped(false);
            this.shutdownDerby();
            this.cleanPersistentStorage();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Problem stopping database", e);
        }
    }

    private void cleanPersistentStorage() {
        File lFile = new File(DATABASE_PATH);
        if (lFile.isFile()) {
            TestCase.fail((String)"A regular file by the name target/db/persistence/derby exists, clean this up first");
        }
        if (!lFile.isDirectory()) {
            return;
        }
        FileSystemUtils.deleteDirRecursively((String)DATABASE_PATH);
    }
}

