/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.persistence;

import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import org.wamblee.general.ThreadSpecificProxyFactory;
import org.wamblee.test.jndi.StubInitialContextFactory;
import org.wamblee.test.persistence.JpaCustomizerBuilder;
import org.wamblee.test.persistence.PersistenceUnitDescription;
import org.wamblee.test.persistence.RequireTransactionStatus;
import org.wamblee.test.persistence.TransactionResultCallback;
import org.wamblee.test.transactions.TransactionResource;
import org.wamblee.test.transactions.TransactionResult;

public class JpaBuilder
implements TransactionResource<EntityManager> {
    private static final Logger LOGGER = Logger.getLogger(JpaBuilder.class.getName());
    private PersistenceUnitDescription persistenceUnit;
    private String url;
    private String user;
    private String password;
    private EntityManagerFactory factory;
    private ThreadSpecificProxyFactory<EntityManager> entityManager;

    public JpaBuilder(String aUrl, String aUser, String aPassword, PersistenceUnitDescription aPersistenceUnit) {
        this.persistenceUnit = aPersistenceUnit;
        this.url = aUrl;
        this.user = aUser;
        this.password = aPassword;
        this.entityManager = new ThreadSpecificProxyFactory(EntityManager.class);
    }

    public void start() throws Exception {
        this.factory = this.createFactory();
        try {
            this.execute(new JpaUnitOfWork<Void>(){

                @Override
                public Void execute(EntityManager aEm) {
                    return null;
                }
            });
        }
        catch (PersistenceException e) {
            this.factory.close();
            throw e;
        }
    }

    public void stop() {
        StubInitialContextFactory.unregister();
        this.factory.close();
    }

    public EntityManagerFactory createFactory() {
        TreeMap<String, String> jpaProps = new TreeMap<String, String>();
        jpaProps.put("javax.persistence.jtaDataSource", null);
        jpaProps.put("javax.persistence.transactionType", "RESOURCE_LOCAL");
        jpaProps.put("javax.persistence.jdbc.url", this.url);
        jpaProps.put("javax.persistence.jdbc.user", this.user);
        jpaProps.put("javax.persistence.jdbc.password", this.password);
        JpaCustomizerBuilder.getCustomizer().customize(this.persistenceUnit, jpaProps);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.persistenceUnit.getUnitName(), jpaProps);
        LOGGER.info("Using " + emf.getClass());
        return emf;
    }

    public <T> T execute(JpaUnitOfWork<T> aWork) throws Exception {
        return this.execute(aWork, new RequireTransactionStatus(TransactionResult.COMMIT));
    }

    public <T> T execute(JpaUnitOfWork<T> aWork, TransactionResultCallback aCallback) throws Exception {
        EntityManager em = this.begin();
        try {
            T value = aWork.execute(em);
            TransactionResult result = this.commit(em);
            aCallback.status(result);
            return value;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception occured", e);
            TransactionResult result = this.rollback(em);
            aCallback.status(result);
            throw e;
        }
    }

    @Override
    public EntityManager begin() {
        EntityManager em = this.factory.createEntityManager();
        EntityTransaction transaction = em.getTransaction();
        transaction.begin();
        this.entityManager.set((Object)em);
        return em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionResult commit(EntityManager aEntityManager) {
        try {
            EntityTransaction transaction = aEntityManager.getTransaction();
            if (transaction.isActive()) {
                if (transaction.getRollbackOnly()) {
                    transaction.rollback();
                    TransactionResult transactionResult = TransactionResult.ROLLBACK;
                    return transactionResult;
                }
                transaction.commit();
                TransactionResult transactionResult = TransactionResult.COMMIT;
                return transactionResult;
            }
            TransactionResult transactionResult = TransactionResult.UNKNOWN;
            return transactionResult;
        }
        finally {
            aEntityManager.close();
            this.entityManager.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionResult rollback(EntityManager aEntityManager) {
        try {
            EntityTransaction transaction = aEntityManager.getTransaction();
            if (transaction.isActive()) {
                transaction.rollback();
                TransactionResult transactionResult = TransactionResult.ROLLBACK;
                return transactionResult;
            }
            TransactionResult transactionResult = TransactionResult.UNKNOWN;
            return transactionResult;
        }
        finally {
            if (aEntityManager.isOpen()) {
                aEntityManager.close();
            }
            this.entityManager.set(null);
        }
    }

    public EntityManager getContextualEntityManager() {
        return (EntityManager)this.entityManager.getProxy();
    }

    public static interface JpaUnitOfWork<T> {
        public T execute(EntityManager var1) throws Exception;
    }
}

