/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test.persistence;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.wamblee.test.jndi.StubInitialContextFactory;
import org.wamblee.test.persistence.Database;
import org.wamblee.test.persistence.DatabaseBuilder;
import org.wamblee.test.persistence.DatabaseUtils;
import org.wamblee.test.persistence.JpaBuilder;
import org.wamblee.test.persistence.JpaCustomizerBuilder;
import org.wamblee.test.persistence.PersistenceUnitDescription;

public class JpaTester {
    private PersistenceUnitDescription persistenceUnit;
    private Database db;
    private DataSource dataSource;
    private DatabaseUtils dbUtils;
    private JpaBuilder jpaBuilder;

    public JpaTester(PersistenceUnitDescription aPersistenceUnit) {
        this.persistenceUnit = aPersistenceUnit;
    }

    public void start() throws Exception {
        this.db = DatabaseBuilder.getDatabase(new String[0]);
        this.dataSource = this.db.start();
        StubInitialContextFactory.register();
        try {
            InitialContext ctx = new InitialContext();
            ctx.bind(this.persistenceUnit.getJndiName(), (Object)this.dataSource);
        }
        catch (NamingException e) {
            throw new RuntimeException("JNDI problem", e);
        }
        this.dbUtils = new DatabaseUtils(this.dataSource);
        this.dbUtils.start();
        this.dbUtils.dropTables(JpaCustomizerBuilder.getCustomizer().getJpaTables());
        this.jpaBuilder = new JpaBuilder(this.db.getJdbcUrl(), this.db.getUsername(), this.db.getPassword(), this.persistenceUnit);
        this.jpaBuilder.start();
    }

    public void stop() {
        if (this.jpaBuilder != null) {
            this.jpaBuilder.stop();
        }
        if (this.dbUtils != null) {
            this.dbUtils.stop();
        }
        if (this.db != null) {
            this.db.stop();
        }
    }

    public Database getDb() {
        return this.db;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DatabaseUtils getDbUtils() {
        return this.dbUtils;
    }

    public JpaBuilder getJpaBuilder() {
        return this.jpaBuilder;
    }

    public PersistenceUnitDescription getPersistenceUnit() {
        return this.persistenceUnit;
    }
}

