/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.wicket.transactions;

import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import org.apache.wicket.Page;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.util.tester.WicketTester;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.wamblee.test.jndi.StubInitialContextFactory;
import org.wamblee.wicket.transactions.MyPage;
import org.wamblee.wicket.transactions.OpenTransactionInViewRequestCycle;

public class OpenTransactionInViewRequestCycleTest {
    private UserTransaction userTransaction;
    private WicketTester wicket;
    public static Runnable BEHAVIOR;

    @Before
    public void setUp() throws Exception {
        this.userTransaction = (UserTransaction)Mockito.mock(UserTransaction.class);
        StubInitialContextFactory.register();
        InitialContext ctx = new InitialContext();
        ctx.bind("java:comp/UserTransaction", (Object)this.userTransaction);
        BEHAVIOR = (Runnable)Mockito.mock(Runnable.class);
        this.wicket = new WicketTester(new WebApplication(){

            public Class<? extends Page> getHomePage() {
                return MyPage.class;
            }

            public RequestCycle newRequestCycle(Request aRequest, Response aResponse) {
                return new OpenTransactionInViewRequestCycle((WebApplication)this, (WebRequest)aRequest, aResponse);
            }
        });
    }

    @After
    public void tearDown() {
        StubInitialContextFactory.unregister();
    }

    private void stubTransactionBehavior(int aStatus) throws Exception {
        Mockito.when((Object)this.userTransaction.getStatus()).thenReturn((Object)aStatus);
        ((UserTransaction)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock aInvocation) throws Throwable {
                Mockito.when((Object)OpenTransactionInViewRequestCycleTest.this.userTransaction.getStatus()).thenReturn((Object)9);
                return null;
            }
        }).when((Object)this.userTransaction)).rollback();
    }

    @Test
    public void testCommittedTransaction() throws Exception {
        this.stubTransactionBehavior(0);
        this.wicket.startPage(MyPage.class);
        this.wicket.assertRenderedPage(MyPage.class);
        InOrder inorder = Mockito.inOrder((Object[])new Object[]{this.userTransaction});
        ((UserTransaction)inorder.verify((Object)this.userTransaction)).begin();
        ((UserTransaction)inorder.verify((Object)this.userTransaction)).commit();
        ((UserTransaction)Mockito.verify((Object)this.userTransaction, (VerificationMode)Mockito.never())).rollback();
    }

    @Test
    public void testRolledbackTransaction() throws Exception {
        this.stubTransactionBehavior(0);
        ((Runnable)Mockito.doThrow((Throwable)new RuntimeException("Page rendering fails")).when((Object)BEHAVIOR)).run();
        try {
            this.wicket.startPage(MyPage.class);
            Assert.fail();
        }
        catch (WicketRuntimeException e) {
            InOrder inorder = Mockito.inOrder((Object[])new Object[]{this.userTransaction});
            ((UserTransaction)inorder.verify((Object)this.userTransaction)).begin();
            ((UserTransaction)inorder.verify((Object)this.userTransaction)).rollback();
            ((UserTransaction)Mockito.verify((Object)this.userTransaction, (VerificationMode)Mockito.never())).commit();
        }
    }

    @Test
    public void testMarkTransactionForRollback() throws Exception {
        this.stubTransactionBehavior(1);
        this.wicket.startPage(MyPage.class);
        InOrder inorder = Mockito.inOrder((Object[])new Object[]{this.userTransaction});
        ((UserTransaction)inorder.verify((Object)this.userTransaction)).begin();
        ((UserTransaction)inorder.verify((Object)this.userTransaction)).rollback();
        ((UserTransaction)Mockito.verify((Object)this.userTransaction, (VerificationMode)Mockito.never())).commit();
    }
}

