/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.wicket.model;

import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.wamblee.persistence.Detachable;
import org.wamblee.wicket.model.DetachableEntity;

public class DetachableEntityTest {
    private X initialValue;
    private Detachable<X> detachable;
    private DetachableEntity<X> entity;

    @Before
    public void setUp() {
        this.initialValue = (X)Mockito.mock(X.class);
        this.detachable = (Detachable)Mockito.mock(Detachable.class);
        Mockito.when((Object)this.detachable.get()).thenReturn((Object)this.initialValue);
        this.entity = new DetachableEntity(this.detachable);
    }

    @Test
    public void testGetObject() {
        X x = new X();
        Mockito.reset((Object[])new Detachable[]{this.detachable});
        Mockito.when((Object)this.detachable.get()).thenReturn((Object)x);
        X value = (X)this.entity.getObject();
        TestCase.assertSame((Object)this.initialValue, (Object)value);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.detachable});
    }

    @Test
    public void testOnDetachReattach() {
        X x = new X();
        Mockito.when((Object)this.detachable.get()).thenReturn((Object)x);
        this.entity.detach();
        ((Detachable)Mockito.verify(this.detachable)).detach();
        Mockito.reset((Object[])new Detachable[]{this.detachable});
        Mockito.when((Object)this.detachable.get()).thenReturn((Object)x);
        X y = (X)this.entity.getObject();
        TestCase.assertSame((Object)x, (Object)y);
        ((Detachable)Mockito.verify(this.detachable)).get();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetObject() {
        X x = new X();
        this.entity.setObject((Object)x);
    }

    public static class X {
    }
}

