/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.wicket.transactions;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.apache.wicket.Page;
import org.apache.wicket.Response;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebRequestCycle;

public class OpenTransactionInViewRequestCycle
extends WebRequestCycle {
    private static final Logger LOG = Logger.getLogger(OpenTransactionInViewRequestCycle.class.getName());
    private static final String JAVA_COMP_USER_TRANSACTION_JNDI = "java:comp/UserTransaction";
    private UserTransaction userTransaction = this.getUserTransaction();

    public OpenTransactionInViewRequestCycle(WebApplication aApplication, WebRequest aRequest, Response aResponse) {
        super(aApplication, aRequest, aResponse);
    }

    protected void onBeginRequest() {
        try {
            this.userTransaction.begin();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start transaction", e);
        }
        super.onBeginRequest();
    }

    protected void onEndRequest() {
        try {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Transaction status: " + this.userTransaction.getStatus());
            }
            if (this.userTransaction.getStatus() == 0) {
                this.userTransaction.commit();
            } else if (this.userTransaction.getStatus() == 1) {
                this.userTransaction.rollback();
            } else {
                LOG.warning("Transaction status is '" + this.userTransaction.getStatus() + "' not committing or rolling back");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not commit transaction", e);
        }
        super.onEndRequest();
    }

    public Page onRuntimeException(Page aPage, RuntimeException aE) {
        super.onEndRequest();
        try {
            this.userTransaction.rollback();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not rollback transaction", e);
        }
        return super.onRuntimeException(aPage, aE);
    }

    private UserTransaction getUserTransaction() {
        try {
            InitialContext ctx = new InitialContext();
            return (UserTransaction)ctx.lookup(JAVA_COMP_USER_TRANSACTION_JNDI);
        }
        catch (NamingException e) {
            throw new RuntimeException("Could not obtain user transaction object");
        }
    }
}

