/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.wicket.inject;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.AbstractBehavior;
import org.wamblee.inject.InjectorBuilder;

/**
 * Injection behavior that performs dependency injection after
 * serialization/deserialisation of the object.
 * 
 * @author Erik Brakkee
 * 
 */
public class InjectionBehavior extends AbstractBehavior {

    private static final long serialVersionUID = 7363393083209418693L;
    private transient boolean injectionUptodate;

    /**
     * Constructs the behavior.
     */
    public InjectionBehavior() {
        injectionUptodate = true;
    }

    @Override
    public void beforeRender(Component aComponent) {
        if (!injectionUptodate) {
            InjectorBuilder.getInjector().inject(aComponent);
            injectionUptodate = true;
        }
    }
}
