/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.wicket.inject;

import org.apache.wicket.Component;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.wamblee.general.ObjectSerializationUtils;
import org.wamblee.inject.Injector;
import org.wamblee.inject.InjectorBuilder;
import org.wamblee.inject.InjectorFactory;
import org.wamblee.wicket.inject.InjectionBehavior;

public class InjectionBehaviorTest {
    private Component component;
    private Injector injector;
    private InjectorFactory injectorFactory;

    @Before
    public void setUp() {
        this.component = (Component)Mockito.mock(Component.class);
        this.injector = (Injector)Mockito.mock(Injector.class);
        this.injectorFactory = (InjectorFactory)Mockito.mock(InjectorFactory.class);
        Mockito.when((Object)this.injectorFactory.create((Class)Mockito.any(Class.class))).thenReturn((Object)this.injector);
        InjectorBuilder.setInjectorFactory((InjectorFactory)this.injectorFactory);
    }

    @After
    public void tearDown() {
        InjectorBuilder.setInjectorFactory(null);
    }

    @Test
    public void testNoInjectionInitially() {
        Component component = (Component)Mockito.mock(Component.class);
        InjectionBehavior behavior = new InjectionBehavior(component);
        behavior.beforeRender(component);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.injector});
    }

    @Test
    public void testInjectOnlyOnceAfterDeserialisation() throws Exception {
        Component component = (Component)Mockito.mock(Component.class);
        InjectionBehavior behavior = new InjectionBehavior(component);
        behavior = (InjectionBehavior)ObjectSerializationUtils.deserialize((byte[])ObjectSerializationUtils.serialize((Object)behavior), InjectionBehavior.class);
        ((Injector)Mockito.verify((Object)this.injector)).inject(Mockito.any(Component.class));
        Mockito.reset((Object[])new Injector[]{this.injector});
        behavior.beforeRender(component);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.injector});
    }
}

