/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate;

import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.watertemplate.TemplateMap;
import org.watertemplate.TemplateRenderer;

public abstract class Template {
    private static final Locale DEFAULT_LOCALE = Locale.US;
    final TemplateMap.Arguments arguments = new TemplateMap.Arguments();

    protected Template getMasterTemplate() {
        return null;
    }

    protected abstract String getFilePath();

    protected void addSubTemplates(TemplateMap.SubTemplates subTemplates) {
    }

    protected Locale getDefaultLocale() {
        return DEFAULT_LOCALE;
    }

    public final String render() {
        return this.render(this.getDefaultLocale());
    }

    public final String render(Locale locale) {
        return new TemplateRenderer(this, locale).render();
    }

    protected final void add(String key, String value) {
        this.arguments.add(key, value);
    }

    protected final void add(String key, Boolean someCondition) {
        this.arguments.add(key, someCondition);
    }

    protected final <T> void addMappedObject(String key, T object, Consumer<TemplateMap.Arguments> mapper) {
        this.addMappedObject(key, object, (T a, TemplateMap.Arguments b) -> mapper.accept((TemplateMap.Arguments)b));
    }

    protected final <T> void addMappedObject(String key, T object, BiConsumer<T, TemplateMap.Arguments> mapper) {
        this.arguments.addMappedObject(key, object, mapper);
    }

    protected final <T> void addCollection(String key, Iterable<T> iterable, BiConsumer<T, TemplateMap.Arguments> mapper) {
        this.arguments.addCollection(key, iterable, mapper);
    }

    protected final <T> void addLocaleSensitiveObject(String key, T object, BiFunction<T, Locale, String> function) {
        this.arguments.addLocaleSensitiveObject(key, object, function);
    }
}

