/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.watertemplate.Template;
import org.watertemplate.TemplateObject;

public abstract class TemplateMap<T> {
    public final Map<String, T> map = new HashMap<String, T>();

    public final void add(String key, T value) {
        this.map.put(key, value);
    }

    public static final class Arguments
    extends TemplateMap<TemplateObject> {
        public final <T> void addCollection(String key, Iterable<T> iterable) {
            this.add(key, new TemplateObject.CollectionObject<Object>(iterable, (a, b) -> {}));
        }

        public final <T> void addCollection(String key, Iterable<T> iterable, BiConsumer<T, Arguments> mapper) {
            this.add(key, new TemplateObject.CollectionObject<T>(iterable, mapper));
        }

        public final <T> void addMappedObject(String key, T object, BiConsumer<T, Arguments> mapper) {
            this.add(key, new TemplateObject.MappedObject<T>(object, mapper));
        }

        public final <T> void addLocaleSensitiveObject(String key, T object, BiFunction<T, Locale, String> function) {
            this.add(key, new TemplateObject.LocaleSensitiveObject<T>(object, function));
        }

        @Override
        public final void add(String key, String value) {
            this.add(key, new TemplateObject.StringObject(value));
        }

        @Override
        public final void add(String key, Boolean value) {
            this.add(key, new TemplateObject.ConditionObject(value));
        }

        public final TemplateObject get(String key) {
            return (TemplateObject)this.map.get(key);
        }

        public final void remove(String key) {
            this.map.remove(key);
        }
    }

    public static class SubTemplates
    extends TemplateMap<TemplateObject.SubTemplateObject> {
        SubTemplates() {
        }

        @Override
        public final void add(String key, Template subTemplate) {
            this.add(key, new TemplateObject.SubTemplateObject(subTemplate));
        }
    }
}

