/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate;

import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.watertemplate.Template;
import org.watertemplate.TemplateMap;
import org.watertemplate.exception.InvalidTemplateObjectEvaluationException;

public interface TemplateObject<T> {
    public T evaluate(Locale var1);

    public static abstract class Mappable<T> {
        private final BiConsumer<T, TemplateMap.Arguments> mapper;

        Mappable(BiConsumer<T, TemplateMap.Arguments> mapper) {
            this.mapper = mapper;
        }

        public TemplateMap.Arguments map(T object) {
            TemplateMap.Arguments arguments = new TemplateMap.Arguments();
            this.mapper.accept(object, arguments);
            return arguments;
        }

        public BiConsumer<T, TemplateMap.Arguments> getMapper() {
            return this.mapper;
        }
    }

    public static class SubTemplateObject
    implements TemplateObject<String> {
        private final Template subTemplate;

        public SubTemplateObject(Template subTemplate) {
            this.subTemplate = subTemplate;
        }

        @Override
        public String evaluate(Locale locale) {
            return this.subTemplate.render(locale);
        }
    }

    public static class StringObject
    implements TemplateObject<String> {
        private final String value;

        public StringObject(String value) {
            this.value = value;
        }

        @Override
        public String evaluate(Locale locale) {
            return this.value;
        }
    }

    public static class ConditionObject
    implements TemplateObject<Boolean> {
        private final Boolean value;

        public ConditionObject(Boolean value) {
            this.value = value;
        }

        @Override
        public Boolean evaluate(Locale locale) {
            return this.value;
        }
    }

    public static final class CollectionObject<T>
    extends Mappable<T>
    implements TemplateObject {
        private final Iterable<T> iterable;

        public CollectionObject(Iterable<T> iterable, BiConsumer<T, TemplateMap.Arguments> mapper) {
            super(mapper);
            this.iterable = iterable;
        }

        public Boolean isEmpty() {
            return this.iterable == null || !this.iterable.iterator().hasNext();
        }

        public Iterable<T> getIterable() {
            return this.iterable;
        }

        public Object evaluate(Locale locale) {
            throw new InvalidTemplateObjectEvaluationException("Collections should not be evaluated");
        }
    }

    public static final class MappedObject<T>
    extends Mappable<T>
    implements TemplateObject<String> {
        private final T object;

        MappedObject(T object, BiConsumer<T, TemplateMap.Arguments> mapper) {
            super(mapper);
            this.object = object;
        }

        public TemplateMap.Arguments map() {
            return this.map(this.object);
        }

        @Override
        public String evaluate(Locale locale) {
            if (this.object instanceof String) {
                return (String)this.object;
            }
            throw new InvalidTemplateObjectEvaluationException("MappedObjects should not be evaluated. If you're iterating, make sure your collection contains only Strings.");
        }
    }

    public static final class LocaleSensitiveObject<T>
    implements TemplateObject<String> {
        private final BiFunction<T, Locale, String> function;
        private final T object;

        protected LocaleSensitiveObject(T object, BiFunction<T, Locale, String> function) {
            this.function = function;
            this.object = object;
        }

        @Override
        public String evaluate(Locale locale) {
            return this.function.apply(this.object, locale);
        }
    }
}

