/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate;

import java.util.Locale;
import org.watertemplate.Template;
import org.watertemplate.TemplateMap;
import org.watertemplate.exception.RenderException;
import org.watertemplate.interpreter.WaterInterpreter;

class TemplateRenderer {
    private final Template template;
    private final Locale locale;

    public TemplateRenderer(Template template, Locale locale) {
        this.template = template;
        this.locale = locale;
    }

    public String render() {
        try {
            String renderedTemplateWithRenderedSubTemplates = this.renderTemplateWithSubTemplates();
            return this.renderMasterTemplateIfNecessary(renderedTemplateWithRenderedSubTemplates);
        }
        catch (RuntimeException e) {
            throw new RenderException(this.template, this.locale, e);
        }
    }

    private String renderMasterTemplateIfNecessary(String renderedTemplateWithoutMasterTemplate) {
        Template masterTemplate = this.template.getMasterTemplate();
        if (masterTemplate == null) {
            return renderedTemplateWithoutMasterTemplate;
        }
        masterTemplate.add("content", renderedTemplateWithoutMasterTemplate);
        return masterTemplate.render(this.locale);
    }

    private String renderTemplateWithSubTemplates() {
        this.addSubTemplatesAsArguments();
        return this.renderTemplate();
    }

    private void addSubTemplatesAsArguments() {
        TemplateMap.SubTemplates subTemplates = new TemplateMap.SubTemplates();
        this.template.addSubTemplates(subTemplates);
        subTemplates.map.forEach(this.template.arguments::add);
    }

    private String renderTemplate() {
        String filePath = this.template.getFilePath();
        TemplateMap.Arguments arguments = this.template.arguments;
        Locale defaultLocale = this.template.getDefaultLocale();
        WaterInterpreter interpreter = new WaterInterpreter(filePath, arguments, defaultLocale);
        return interpreter.interpret(this.locale);
    }
}

