/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate.interpreter;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.watertemplate.TemplateMap;
import org.watertemplate.interpreter.Interpreter;
import org.watertemplate.interpreter.exception.TemplateFileNotFoundException;
import org.watertemplate.interpreter.lexer.Lexer;
import org.watertemplate.interpreter.lexer.Token;
import org.watertemplate.interpreter.parser.AbstractSyntaxTree;
import org.watertemplate.interpreter.parser.Parser;
import org.watertemplate.interpreter.reader.Reader;

public class WaterInterpreter
implements Interpreter {
    private static final Map<String, AbstractSyntaxTree> cache = new HashMap<String, AbstractSyntaxTree>();
    private final String templateFilePath;
    private final TemplateMap.Arguments arguments;
    private final Locale defaultLocale;

    public WaterInterpreter(String templateFilePath, TemplateMap.Arguments arguments, Locale defaultLocale) {
        this.templateFilePath = templateFilePath;
        this.arguments = arguments;
        this.defaultLocale = defaultLocale;
    }

    @Override
    public String interpret(Locale locale) {
        String cacheKey = this.cacheKey(locale);
        if (cache.containsKey(cacheKey)) {
            return cache.get(cacheKey).evaluate(this.arguments, locale);
        }
        File templateFile = this.findTemplateFileWith(locale);
        List<Token> tokens = this.lex(templateFile);
        AbstractSyntaxTree abs = this.parse(tokens);
        cache.put(cacheKey, abs);
        return abs.evaluate(this.arguments, locale);
    }

    private File findTemplateFileWith(Locale locale) {
        String templateFileURI = "templates" + File.separator + locale + File.separator + this.templateFilePath;
        URL url = this.getClass().getClassLoader().getResource(templateFileURI);
        if (url != null) {
            return new File(url.getFile());
        }
        if (!locale.equals(this.defaultLocale)) {
            return this.findTemplateFileWith(this.defaultLocale);
        }
        throw new TemplateFileNotFoundException(this.templateFilePath);
    }

    private List<Token> lex(File templateFile) {
        Lexer lexer = new Lexer();
        Reader reader = new Reader(templateFile);
        reader.readExecuting(lexer::accept);
        List<Token> tokens = lexer.getTokens();
        tokens.add(Token.END_OF_INPUT);
        return tokens;
    }

    private AbstractSyntaxTree parse(List<Token> tokens) {
        return new Parser(tokens).buildAbstractSyntaxTree();
    }

    private String cacheKey(Locale locale) {
        return this.templateFilePath + locale;
    }
}

