/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate.interpreter.lexer;

import java.util.List;
import java.util.function.Consumer;
import org.watertemplate.interpreter.lexer.Keyword;
import org.watertemplate.interpreter.lexer.Token;
import org.watertemplate.interpreter.lexer.TokenType;
import org.watertemplate.interpreter.lexer.Tokens;
import org.watertemplate.interpreter.lexer.exception.IncompleteTokenException;

public class Lexer {
    private final Tokens tokens = new Tokens();
    private Consumer<Character> readMode = this::text;
    private int lineNumber = 0;
    private int columnNumber = 0;

    public void accept(Character character) {
        switch (character.charValue()) {
            case '\n': {
                ++this.lineNumber;
                this.columnNumber = 0;
            }
        }
        this.readMode.accept(character);
        ++this.columnNumber;
    }

    private void text(Character character) {
        switch (character.charValue()) {
            case '~': {
                this.tokens.acceptFirstIfNotEmpty(TokenType.TEXT);
                this.readMode = this::commandOrPropertyEvaluation;
                break;
            }
            case ':': {
                this.tokens.acceptFirstIfNotEmpty(TokenType.TEXT);
                this.readMode = this::endOfBlock;
                break;
            }
            case '\u0000': {
                this.tokens.acceptFirstIfNotEmpty(TokenType.TEXT);
                break;
            }
            default: {
                this.tokens.append(character);
            }
        }
    }

    private void commandOrPropertyEvaluation(Character character) {
        switch (character.charValue()) {
            case ':': {
                this.tokens.acceptFirstIfNotEmpty(TokenType.PROPERTY_KEY);
                this.readMode = this::text;
                break;
            }
            case '~': {
                this.tokens.acceptFirstIfNotEmpty(TokenType.PROPERTY_KEY);
                this.readMode = this::text;
                break;
            }
            case '\t': 
            case '\n': 
            case ' ': {
                this.tokens.acceptFirstIfNotEmpty(TokenType.IF, TokenType.FOR, TokenType.IN, TokenType.PROPERTY_KEY);
                this.readMode = this::whiteSpacesInsideCommandEnvironment;
                break;
            }
            case '.': {
                this.tokens.acceptFirstIfNotEmpty(TokenType.PROPERTY_KEY);
                this.tokens.append(character);
                this.tokens.acceptFirstIfNotEmpty(TokenType.ACCESSOR);
                break;
            }
            case '\u0000': {
                throw new IncompleteTokenException(this.lineNumber, this.columnNumber);
            }
            default: {
                this.tokens.append(character);
            }
        }
    }

    private void endOfBlock(Character character) {
        switch (character.charValue()) {
            case ':': {
                this.tokens.acceptFirstIfNotEmpty(TokenType.ELSE);
                this.readMode = this::text;
                break;
            }
            case '~': {
                Keyword.END.getStringRepresentation().chars().forEach(c -> this.tokens.append(Character.valueOf((char)c)));
                this.tokens.acceptFirstIfNotEmpty(TokenType.END);
                this.readMode = this::text;
                break;
            }
            default: {
                this.tokens.append(character);
            }
        }
    }

    private void whiteSpacesInsideCommandEnvironment(Character character) {
        switch (character.charValue()) {
            case '\t': 
            case '\n': 
            case ' ': {
                break;
            }
            case ':': {
                this.readMode = this::text;
                break;
            }
            default: {
                this.readMode = this::commandOrPropertyEvaluation;
                this.commandOrPropertyEvaluation(character);
            }
        }
    }

    public List<Token> getTokens() {
        return this.tokens.all();
    }
}

