/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate.interpreter.lexer;

import java.util.regex.Pattern;
import org.watertemplate.interpreter.lexer.Keyword;

public enum TokenType {
    PROPERTY_KEY{

        @Override
        public boolean accept(String string) {
            return PROPERTY_KEY_PATTERN.matcher(string).matches();
        }
    }
    ,
    IF{

        @Override
        public boolean accept(String string) {
            return Keyword.IF.getStringRepresentation().equals(string);
        }
    }
    ,
    FOR{

        @Override
        public boolean accept(String string) {
            return Keyword.FOR.getStringRepresentation().equals(string);
        }
    }
    ,
    ELSE{

        @Override
        public boolean accept(String string) {
            return Keyword.ELSE.getStringRepresentation().equals(string);
        }
    }
    ,
    IN{

        @Override
        public boolean accept(String string) {
            return Keyword.IN.getStringRepresentation().equals(string);
        }
    }
    ,
    END{

        @Override
        public boolean accept(String string) {
            return Keyword.END.getStringRepresentation().equals(string);
        }
    }
    ,
    ACCESSOR{

        @Override
        public boolean accept(String string) {
            return ".".equals(string);
        }
    }
    ,
    TEXT,
    END_OF_INPUT;

    private static final Pattern PROPERTY_KEY_PATTERN;

    public boolean accept(String string) {
        return true;
    }

    static {
        PROPERTY_KEY_PATTERN = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");
    }
}

