/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate.interpreter.lexer;

import java.util.ArrayList;
import java.util.List;
import org.watertemplate.interpreter.lexer.Token;
import org.watertemplate.interpreter.lexer.TokenType;
import org.watertemplate.interpreter.lexer.exception.InvalidTokenException;

class Tokens {
    private final List<Token> tokens = new ArrayList<Token>();
    private StringBuilder currentTokenValue = new StringBuilder();

    void acceptFirstIfNotEmpty(TokenType ... types) {
        if (this.currentTokenValue.length() == 0) {
            return;
        }
        String tokenValue = this.currentTokenValue.toString();
        for (TokenType type : types) {
            if (!type.accept(tokenValue)) continue;
            this.tokens.add(new Token(tokenValue, type));
            this.currentTokenValue = new StringBuilder();
            return;
        }
        throw new InvalidTokenException(tokenValue, types[types.length - 1]);
    }

    Tokens append(Character c) {
        this.currentTokenValue.append(c);
        return this;
    }

    List<Token> all() {
        return this.tokens;
    }
}

