/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate.interpreter.parser;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import org.watertemplate.TemplateMap;
import org.watertemplate.TemplateObject;
import org.watertemplate.interpreter.parser.exception.IdCouldNotBeResolvedException;
import org.watertemplate.interpreter.parser.exception.NotCollectionObjectException;

public abstract class AbstractSyntaxTree {
    public String evaluate(TemplateMap.Arguments arguments, Locale locale) {
        return this.run(arguments, locale).evaluate(locale).toString();
    }

    abstract TemplateObject run(TemplateMap.Arguments var1, Locale var2);

    public static class Empty
    extends AbstractSyntaxTree {
        @Override
        TemplateObject run(TemplateMap.Arguments arguments, Locale locale) {
            return new TemplateObject.StringObject("");
        }
    }

    public static class Text
    extends AbstractSyntaxTree {
        private final String value;

        public Text(String value) {
            this.value = value;
        }

        @Override
        TemplateObject run(TemplateMap.Arguments arguments, Locale locale) {
            return new TemplateObject.StringObject(this.value);
        }
    }

    public static class Statements
    extends AbstractSyntaxTree {
        private final List<AbstractSyntaxTree> abstractSyntaxTrees;

        public Statements(List<AbstractSyntaxTree> abstractSyntaxTrees) {
            this.abstractSyntaxTrees = abstractSyntaxTrees;
        }

        public Statements(AbstractSyntaxTree ... abstractSyntaxTrees) {
            this.abstractSyntaxTrees = Arrays.asList(abstractSyntaxTrees);
        }

        @Override
        TemplateObject run(TemplateMap.Arguments arguments, Locale locale) {
            StringBuilder sb = new StringBuilder();
            for (AbstractSyntaxTree abstractSyntaxTree : this.abstractSyntaxTrees) {
                sb.append(abstractSyntaxTree.evaluate(arguments, locale));
            }
            return new TemplateObject.StringObject(sb.toString());
        }
    }

    public static class If
    extends AbstractSyntaxTree {
        private final Id conditionId;
        private final AbstractSyntaxTree ifStatements;
        private final AbstractSyntaxTree elseStatements;

        public If(Id conditionId, AbstractSyntaxTree ifStatements) {
            this(conditionId, ifStatements, new Empty());
        }

        public If(Id conditionId, AbstractSyntaxTree ifStatements, AbstractSyntaxTree elseStatements) {
            this.conditionId = conditionId;
            this.ifStatements = ifStatements;
            this.elseStatements = elseStatements;
        }

        @Override
        TemplateObject run(TemplateMap.Arguments arguments, Locale locale) {
            if (((Boolean)this.conditionId.run(arguments, locale).evaluate(locale)).booleanValue()) {
                return this.ifStatements.run(arguments, locale);
            }
            return this.elseStatements.run(arguments, locale);
        }
    }

    public static class Id
    extends AbstractSyntaxTree {
        private final String propertyKey;
        private final Id nestedId;

        public Id(String propertyKey) {
            this(propertyKey, null);
        }

        public Id(String propertyKey, Id nestedId) {
            this.propertyKey = propertyKey;
            this.nestedId = nestedId;
        }

        @Override
        TemplateObject run(TemplateMap.Arguments arguments, Locale locale) {
            TemplateObject object = arguments.get(this.propertyKey);
            if (object == null) {
                throw new IdCouldNotBeResolvedException(this);
            }
            if (this.nestedId == null) {
                return object;
            }
            if (!(object instanceof TemplateObject.MappedObject)) {
                throw new IdCouldNotBeResolvedException(this);
            }
            try {
                TemplateMap.Arguments mappedProperties = ((TemplateObject.MappedObject)object).map();
                return this.nestedId.run(mappedProperties, locale);
            }
            catch (IdCouldNotBeResolvedException e) {
                throw new IdCouldNotBeResolvedException(this);
            }
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }

        public String getFullId() {
            if (this.nestedId == null) {
                return this.propertyKey;
            }
            return this.propertyKey + '.' + this.nestedId.getFullId();
        }
    }

    public static class For
    extends AbstractSyntaxTree {
        private final String variableName;
        private final Id collectionId;
        private final AbstractSyntaxTree forStatements;
        private final AbstractSyntaxTree elseStatements;

        public For(String variableName, Id collectionId, AbstractSyntaxTree forStatements) {
            this(variableName, collectionId, forStatements, new Empty());
        }

        public For(String variableName, Id collectionId, AbstractSyntaxTree forStatements, AbstractSyntaxTree elseStatements) {
            this.variableName = variableName;
            this.collectionId = collectionId;
            this.forStatements = forStatements;
            this.elseStatements = elseStatements;
        }

        @Override
        TemplateObject run(TemplateMap.Arguments arguments, Locale locale) {
            TemplateObject collection = this.collectionId.run(arguments, locale);
            if (!(collection instanceof TemplateObject.CollectionObject)) {
                throw new NotCollectionObjectException(this.collectionId);
            }
            TemplateObject.CollectionObject collectionObject = (TemplateObject.CollectionObject)collection;
            if (collectionObject.isEmpty().booleanValue()) {
                return this.elseStatements.run(arguments, locale);
            }
            StringBuilder sb = new StringBuilder();
            BiConsumer mapper = collectionObject.getMapper();
            for (Object item : collectionObject.getIterable()) {
                arguments.addMappedObject(this.variableName, item, mapper);
                sb.append(this.forStatements.evaluate(arguments, locale));
            }
            arguments.remove(this.variableName);
            return new TemplateObject.StringObject(sb.toString());
        }
    }
}

