/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate.interpreter.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.watertemplate.interpreter.parser.AbstractSyntaxTree;
import org.watertemplate.interpreter.parser.GrammarSymbol;
import org.watertemplate.interpreter.parser.NonTerminal;
import org.watertemplate.interpreter.parser.Terminal;
import org.watertemplate.interpreter.parser.TokenStream;
import org.watertemplate.interpreter.parser.exception.ParseException;

abstract class Production
implements GrammarSymbol {
    private final List<GrammarSymbol> symbols;

    Production(GrammarSymbol ... symbols) {
        this.symbols = Arrays.asList(symbols);
    }

    @Override
    public AbstractSyntaxTree buildAbstractSyntaxTree(TokenStream tokenStream) {
        ArrayList<AbstractSyntaxTree> abstractSyntaxTrees = new ArrayList<AbstractSyntaxTree>();
        int save = tokenStream.getCurrentTokenPosition();
        try {
            for (GrammarSymbol symbol : this.symbols) {
                abstractSyntaxTrees.add(symbol.buildAbstractSyntaxTree(tokenStream));
            }
        }
        catch (ParseException e) {
            tokenStream.reset(save);
            throw e;
        }
        return this.zip(abstractSyntaxTrees);
    }

    abstract AbstractSyntaxTree zip(List<AbstractSyntaxTree> var1);

    static class Empty
    extends Production {
        Empty() {
            super(new GrammarSymbol[0]);
        }

        @Override
        AbstractSyntaxTree zip(List<AbstractSyntaxTree> statements) {
            return new AbstractSyntaxTree.Empty();
        }
    }

    static class Statements
    extends Production {
        public Statements(GrammarSymbol ... statements) {
            super(statements);
        }

        @Override
        AbstractSyntaxTree zip(List<AbstractSyntaxTree> statements) {
            return new AbstractSyntaxTree.Statements(statements);
        }
    }

    static class IdWithNestedProperties
    extends Production {
        IdWithNestedProperties() {
            super(Terminal.PROPERTY_KEY, Terminal.ACCESSOR, NonTerminal.ID);
        }

        @Override
        AbstractSyntaxTree zip(List<AbstractSyntaxTree> statements) {
            String propertyKey = ((AbstractSyntaxTree.Id)statements.get(0)).getPropertyKey();
            AbstractSyntaxTree.Id nestedId = (AbstractSyntaxTree.Id)statements.get(2);
            return new AbstractSyntaxTree.Id(propertyKey, nestedId);
        }
    }

    static class ForElse
    extends Production {
        ForElse() {
            super(Terminal.FOR, Terminal.PROPERTY_KEY, Terminal.IN, NonTerminal.ID, NonTerminal.STATEMENTS, Terminal.ELSE, NonTerminal.STATEMENTS, Terminal.END);
        }

        @Override
        AbstractSyntaxTree zip(List<AbstractSyntaxTree> statements) {
            String propertyKey = ((AbstractSyntaxTree.Id)statements.get(1)).getPropertyKey();
            AbstractSyntaxTree.Id collectionId = (AbstractSyntaxTree.Id)statements.get(3);
            AbstractSyntaxTree forStatements = statements.get(4);
            AbstractSyntaxTree elseStatements = statements.get(6);
            return new AbstractSyntaxTree.For(propertyKey, collectionId, forStatements, elseStatements);
        }
    }

    static class For
    extends Production {
        For() {
            super(Terminal.FOR, Terminal.PROPERTY_KEY, Terminal.IN, NonTerminal.ID, NonTerminal.STATEMENTS, Terminal.END);
        }

        @Override
        AbstractSyntaxTree zip(List<AbstractSyntaxTree> statements) {
            String propertyKey = ((AbstractSyntaxTree.Id)statements.get(1)).getPropertyKey();
            AbstractSyntaxTree.Id collectionId = (AbstractSyntaxTree.Id)statements.get(3);
            AbstractSyntaxTree forStatements = statements.get(4);
            return new AbstractSyntaxTree.For(propertyKey, collectionId, forStatements);
        }
    }

    static class IfElse
    extends Production {
        IfElse() {
            super(Terminal.IF, NonTerminal.ID, NonTerminal.STATEMENTS, Terminal.ELSE, NonTerminal.STATEMENTS, Terminal.END);
        }

        @Override
        AbstractSyntaxTree zip(List<AbstractSyntaxTree> statements) {
            AbstractSyntaxTree.Id conditionId = (AbstractSyntaxTree.Id)statements.get(1);
            AbstractSyntaxTree ifStatements = statements.get(2);
            AbstractSyntaxTree elseStatements = statements.get(4);
            return new AbstractSyntaxTree.If(conditionId, ifStatements, elseStatements);
        }
    }

    static class If
    extends Production {
        If() {
            super(Terminal.IF, NonTerminal.ID, NonTerminal.STATEMENTS, Terminal.END);
        }

        @Override
        AbstractSyntaxTree zip(List<AbstractSyntaxTree> statements) {
            AbstractSyntaxTree.Id conditionId = (AbstractSyntaxTree.Id)statements.get(1);
            AbstractSyntaxTree ifStatements = statements.get(2);
            return new AbstractSyntaxTree.If(conditionId, ifStatements);
        }
    }
}

