/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate.interpreter.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.watertemplate.interpreter.parser.Terminal;
import org.watertemplate.interpreter.parser.Token;

public class Lexer {
    private static final int BUFFER_SIZE = 8192;
    private final char[] buffer = new char[8192];
    private List<Terminal> previousCandidates = new ArrayList<Terminal>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Token> lex(InputStream stream) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream));){
            List<Token> tokens = this.tokenize(bufferedReader);
            tokens.add(Token.END_OF_INPUT);
            List<Token> list = tokens;
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Token> tokenize(BufferedReader bufferedReader) throws IOException {
        int nReadChars;
        StringBuilder accumulator = new StringBuilder();
        ArrayList<Token> tokens = new ArrayList<Token>();
        while ((nReadChars = bufferedReader.read(this.buffer, 0, 8192)) != -1) {
            for (int i = 0; i < nReadChars; ++i) {
                i = this.process(accumulator, tokens, i, this.buffer[i]);
            }
        }
        this.process(accumulator, tokens, 0, '\u0000');
        return tokens;
    }

    private int process(StringBuilder accumulator, List<Token> tokens, int i, char c) {
        String current;
        String previous = accumulator.toString();
        Token accepted = this.tryToAcceptFrom(previous, current = accumulator.append(c).toString());
        if (accepted != null) {
            tokens.add(accepted);
            accumulator.setLength(0);
            return i - 1;
        }
        return i;
    }

    private Token tryToAcceptFrom(String previous, String current) {
        List<Terminal> currentCandidates = Arrays.asList(Terminal.values()).stream().filter(terminal -> terminal.isCandidateFrom(current)).collect(Collectors.toList());
        if (this.containsOnly(Terminal.TEXT, currentCandidates).booleanValue() && this.previousCandidates.isEmpty()) {
            return null;
        }
        if (currentCandidates.isEmpty() && this.previousCandidates.isEmpty()) {
            return new Token(previous, Terminal.TEXT);
        }
        if ((currentCandidates.isEmpty() || this.containsOnly(Terminal.TEXT, currentCandidates).booleanValue()) && !this.previousCandidates.isEmpty()) {
            return this.acceptFrom(previous);
        }
        this.previousCandidates = currentCandidates;
        return null;
    }

    private Token acceptFrom(String string) {
        List<Terminal> allAcceptable = this.previousCandidates.stream().filter(terminal -> terminal.isAcceptableFrom(string)).collect(Collectors.toList());
        this.previousCandidates.clear();
        return new Token(string, allAcceptable);
    }

    private Boolean containsOnly(Terminal terminal, List<Terminal> list) {
        return list.size() == 1 && list.contains(terminal);
    }

    List<Token> tokenize(String input) {
        StringBuilder accumulator = new StringBuilder();
        ArrayList<Token> tokens = new ArrayList<Token>();
        input = input + '\u0000';
        for (int i = 0; i < input.length(); ++i) {
            i = this.process(accumulator, tokens, i, input.charAt(i));
        }
        return tokens;
    }
}

