/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate.interpreter.parser;

import java.util.ArrayList;
import java.util.List;
import org.watertemplate.interpreter.parser.AbstractSyntaxTree;
import org.watertemplate.interpreter.parser.GrammarSymbol;
import org.watertemplate.interpreter.parser.Production;
import org.watertemplate.interpreter.parser.Terminal;
import org.watertemplate.interpreter.parser.TokenStream;
import org.watertemplate.interpreter.parser.exception.ParseException;

enum NonTerminal implements GrammarSymbol
{
    IF_COMMAND{

        @Override
        void addProductions(List<GrammarSymbol> symbols) {
            symbols.add(new Production.If());
            symbols.add(new Production.IfElse());
        }
    }
    ,
    FOR_COMMAND{

        @Override
        void addProductions(List<GrammarSymbol> symbols) {
            symbols.add(new Production.For());
            symbols.add(new Production.ForElse());
        }
    }
    ,
    NESTED_PROP{

        @Override
        void addProductions(List<GrammarSymbol> symbols) {
            symbols.add(new Production.NestedProperty());
            symbols.add(new Production.Empty());
        }
    }
    ,
    ID{

        @Override
        void addProductions(List<GrammarSymbol> symbols) {
            symbols.add(new Production.Id());
            symbols.add(Terminal.PROPERTY_KEY);
        }
    }
    ,
    EVALUATION{

        @Override
        void addProductions(List<GrammarSymbol> symbols) {
            symbols.add(new Production.Evaluation());
        }
    }
    ,
    STATEMENT{

        @Override
        void addProductions(List<GrammarSymbol> symbols) {
            symbols.add(FOR_COMMAND);
            symbols.add(IF_COMMAND);
            symbols.add(EVALUATION);
            symbols.add(Terminal.TEXT);
        }
    }
    ,
    STATEMENTS{

        @Override
        void addProductions(List<GrammarSymbol> symbols) {
            symbols.add(new Production.Statements(STATEMENT, STATEMENTS));
            symbols.add(new Production.Empty());
        }
    }
    ,
    TEMPLATE{

        @Override
        void addProductions(List<GrammarSymbol> symbols) {
            symbols.add(new Production.Statements(STATEMENTS, Terminal.END_OF_INPUT));
        }
    };

    private final List<GrammarSymbol> symbols = new ArrayList<GrammarSymbol>();

    abstract void addProductions(List<GrammarSymbol> var1);

    @Override
    public final AbstractSyntaxTree buildAbstractSyntaxTree(TokenStream tokenStream) throws ParseException {
        ParseException lastException = null;
        for (GrammarSymbol symbol : this.symbols) {
            try {
                return symbol.buildAbstractSyntaxTree(tokenStream);
            }
            catch (ParseException e) {
                lastException = e;
            }
        }
        throw lastException;
    }

    static {
        for (NonTerminal nonTerminal : NonTerminal.values()) {
            nonTerminal.addProductions(nonTerminal.symbols);
        }
    }
}

