/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate.i18n;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.TemplateFunction;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Internationalization {
    private static final Logger LOGGER = LoggerFactory.getLogger(Internationalization.class);
    private final File baseDir;
    private final File destinationDir;
    private final Set<File> alreadyCompiledDirs;
    private final Map<Locale, File> locales;

    public Internationalization(String baseDir, String destinationDir, String bundlesDir) {
        this.baseDir = new File(baseDir);
        this.destinationDir = new File(destinationDir);
        this.alreadyCompiledDirs = new HashSet<File>();
        this.locales = new HashMap<Locale, File>();
        for (File bundleFile : new File(bundlesDir).listFiles()) {
            String[] language_country = FilenameUtils.removeExtension((String)bundleFile.getName()).split("_");
            if (language_country.length == 1) {
                this.locales.put(new Locale(language_country[0]), bundleFile);
                continue;
            }
            this.locales.put(new Locale(language_country[0], language_country[1]), bundleFile);
        }
    }

    public void parse() {
        try {
            long start = System.currentTimeMillis();
            this.createAndCompileFiles();
            LOGGER.info("All files parsed in {}ms", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            LOGGER.error("Deleting i18n directories.");
            Internationalization.deleteFilesOrDirectories(this.alreadyCompiledDirs);
            throw new RuntimeException(e);
        }
    }

    private void createAndCompileFiles() {
        for (Locale locale : this.locales.keySet()) {
            try {
                File localeDir = new File(this.destinationDir, locale.toString());
                LOGGER.info("Parsing {} at {}", (Object)locale, (Object)localeDir);
                FileUtils.deleteDirectory((File)localeDir);
                FileUtils.copyDirectory((File)this.baseDir, (File)localeDir);
                this.alreadyCompiledDirs.add(localeDir);
                this.compileFilesAndDirectoriesFor(locale, localeDir);
            }
            catch (Exception e) {
                LOGGER.error("Error processing {}", (Object)locale);
                throw new RuntimeException(e);
            }
        }
    }

    private void compileFilesAndDirectoriesFor(Locale locale, File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.compileFilesAndDirectoriesFor(locale, file);
                continue;
            }
            this.compileFile(locale, file);
        }
    }

    private void compileFile(Locale locale, File file) throws IOException {
        LOGGER.debug("Parsing {} at {}", (Object)locale, (Object)file);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Before: {} ", (Object)FileUtils.readFileToString((File)file).trim());
        }
        Properties p = new Properties();
        p.load(new FileReader(this.locales.get(locale)));
        HashMap<String, TemplateFunction> func = new HashMap<String, TemplateFunction>();
        func.put("i18n", s -> p.getProperty((String)s, (String)s));
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = mf.compile(file.getAbsolutePath());
        mustache.execute((Writer)new FileWriter(file), func).flush();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("After: {} ", (Object)FileUtils.readFileToString((File)file));
        }
    }

    private static void deleteFilesOrDirectories(Collection<File> files) {
        for (File file : files.toArray(new File[files.size()])) {
            if (file.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)file);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            file.delete();
        }
    }
}

