/*
 * Decompiled with CFR 0.152.
 */
package org.watertemplate.i18n.developer;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryWatcher {
    private final WatchService watcher;
    private final Map<WatchKey, Path> keys;
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryWatcher.class);

    public DirectoryWatcher(String ... dirs) {
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            this.keys = new HashMap<WatchKey, Path>();
            for (String dir : dirs) {
                this.registerAll(Paths.get(dir, new String[0]));
            }
            LOGGER.info("Watching {}", (Object[])dirs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void watchRunning(final Runnable r) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        block5: while (true) {
                            WatchKey key = DirectoryWatcher.this.watcher.take();
                            Path dir = (Path)DirectoryWatcher.this.keys.get(key);
                            Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                            while (true) {
                                boolean valid;
                                if (!iterator.hasNext()) continue block5;
                                WatchEvent<?> event = iterator.next();
                                WatchEvent ev = DirectoryWatcher.cast(event);
                                Path child = dir.resolve((Path)ev.context());
                                if (child.toFile().isFile()) {
                                    LOGGER.info("Rebuilding..");
                                    try {
                                        r.run();
                                    }
                                    catch (Exception e) {
                                        LOGGER.error("Error..", (Throwable)e);
                                    }
                                    if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE && Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) {
                                        DirectoryWatcher.this.registerAll(child);
                                    }
                                }
                                if (valid = key.reset()) continue;
                                DirectoryWatcher.this.keys.remove(key);
                                if (DirectoryWatcher.this.keys.isEmpty()) break;
                            }
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        };
        thread.start();
    }

    private void registerAll(Path dirPath) throws IOException {
        final WatchEvent.Kind[] events = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                WatchKey key = dir.register(DirectoryWatcher.this.watcher, events, SensitivityWatchEventModifier.HIGH);
                DirectoryWatcher.this.keys.put(key, dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }
}

