/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.MyDatabaseExporter;
import org.hibernate.tool.hbm2ddl.MyManagedProviderConnectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.orm.hibernate4.LocalSessionFactoryBean;
import org.springframework.orm.hibernate4.LocalSessionFactoryBuilder;
import org.springframework.util.StringUtils;
import org.web4thejob.orm.HibernateConfiguration;
import org.web4thejob.orm.HibernateInterceptor;

public class CustomSessionFactoryBean
extends LocalSessionFactoryBean
implements HibernateConfiguration {
    private static final Logger LOG = Logger.getLogger(CustomSessionFactoryBean.class);
    private static final String SCHEMA_FILE = "classpath:org/web4thejob/conf/Schema.sql";
    @Autowired
    @Qualifier(value="rootApplicationContext")
    private ApplicationContext applicationContext;
    private String[] classpathMappingResources;

    private void createSchemata(LocalSessionFactoryBuilder sfb) {
        if (!this.applicationContext.getResource(SCHEMA_FILE).exists()) {
            return;
        }
        try {
            ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().applySettings((Map)sfb.getProperties()).buildServiceRegistry();
            MyManagedProviderConnectionHelper connectionHelper = new MyManagedProviderConnectionHelper(sfb.getProperties());
            connectionHelper.prepare(true);
            MyDatabaseExporter myDatabaseExporter = new MyDatabaseExporter((ConnectionHelper)connectionHelper, ((JdbcServices)serviceRegistry.getService(JdbcServices.class)).getSqlExceptionHelper());
            for (String schema : FileUtils.readLines((File)this.applicationContext.getResource(SCHEMA_FILE).getFile())) {
                if (!StringUtils.hasText((String)schema)) continue;
                myDatabaseExporter.export(schema);
            }
            LOG.info((Object)"SCHEMA creation completed successfully.");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error((Object)"Rename file classpath:org/web4thejob/conf/Schema.sql so that you don't get previous error.");
        }
    }

    private void applyInterceptor(LocalSessionFactoryBuilder sfb) {
        sfb.setInterceptor((Interceptor)new HibernateInterceptor());
    }

    protected SessionFactory buildSessionFactory(LocalSessionFactoryBuilder sfb) {
        this.createSchemata(sfb);
        this.applyInterceptor(sfb);
        this.applyResources(sfb);
        return super.buildSessionFactory(sfb);
    }

    private void applyResources(LocalSessionFactoryBuilder sfb) {
        if (this.classpathMappingResources == null) {
            return;
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (String path : this.classpathMappingResources) {
            try {
                for (Resource resource : resolver.getResources(path)) {
                    sfb.addInputStream(resource.getInputStream());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void setClasspathMappingResources(String[] paths) {
        this.classpathMappingResources = paths;
    }
}

