/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.AnnotationMetadata;
import org.web4thejob.orm.DataWriterService;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.Path;
import org.web4thejob.orm.PropertyMetadata;
import org.web4thejob.orm.annotation.DefaultHolder;
import org.web4thejob.orm.query.Condition;
import org.web4thejob.orm.query.Query;

@Repository
class DataWriterServiceImpl
implements DataWriterService {
    @Autowired
    private SessionFactory sessionFactory;

    DataWriterServiceImpl() {
    }

    public <E extends Entity> void delete(E entity) {
        this.sessionFactory.getCurrentSession().buildLockRequest(LockOptions.UPGRADE).lock(entity);
        this.sessionFactory.getCurrentSession().refresh(entity);
        this.sessionFactory.getCurrentSession().delete(entity);
    }

    public <E extends Entity> void save(E entity) {
        this.sessionFactory.getCurrentSession().saveOrUpdate(entity);
        for (AnnotationMetadata defaultHolder : ContextUtil.getMRS().getAnnotationMetadata(entity.getEntityType(), DefaultHolder.class)) {
            this.processDefaultHolder(entity, (AnnotationMetadata<DefaultHolder>)defaultHolder);
        }
    }

    public <E extends Entity> void save(List<E> entities) {
        for (Entity entity : entities) {
            this.save(entity);
        }
    }

    private void processDefaultHolder(Entity entity, AnnotationMetadata<DefaultHolder> defaultHolder) {
        Query query = ContextUtil.getEntityFactory().buildQuery(entity.getEntityType());
        for (String filter : ((DefaultHolder)defaultHolder.getAnnotation()).filters()) {
            query.addCriterion(new Path(filter), Condition.EQ, ContextUtil.getMRS().getPropertyMetadata(entity.getEntityType(), filter).getValue(entity));
        }
        List existingEntities = ContextUtil.getDRS().findByQuery(query);
        PropertyMetadata propertyMetadata = ContextUtil.getMRS().getPropertyMetadata(entity.getEntityType(), defaultHolder.getField().getName());
        boolean currentValue = (Boolean)propertyMetadata.getValue(entity);
        if (existingEntities.size() > 1 && currentValue) {
            for (Entity existingEntity : existingEntities) {
                if (existingEntity.equals((Object)entity) || !((Boolean)propertyMetadata.getValue(existingEntity)).booleanValue()) continue;
                propertyMetadata.setValue(existingEntity, (Object)false);
                this.sessionFactory.getCurrentSession().saveOrUpdate((Object)existingEntity);
            }
        } else if (existingEntities.size() == 1 && !currentValue) {
            propertyMetadata.setValue(entity, (Object)true);
            this.sessionFactory.getCurrentSession().saveOrUpdate((Object)entity);
        }
    }
}

