/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import java.io.Serializable;
import java.sql.Timestamp;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;
import org.web4thejob.SystemProtectedEntryException;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.AnnotationMetadata;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.MetaReaderService;
import org.web4thejob.orm.annotation.InsertTimeHolder;
import org.web4thejob.orm.annotation.UpdateTimeHolder;
import org.web4thejob.orm.annotation.UserIdHolder;
import org.web4thejob.util.CoreUtil;

public class HibernateInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = 1L;
    private static final String INCORRECT_FIELD_INDEX = "incorrect field index in interceptor";

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        boolean engaged = false;
        MetaReaderService mrs = ContextUtil.getMRS();
        for (AnnotationMetadata metadata : mrs.getAnnotationMetadata(((Entity)entity).getEntityType(), UpdateTimeHolder.class)) {
            if (!metadata.getName().equals(propertyNames[metadata.getIndex()])) {
                throw new IllegalStateException(INCORRECT_FIELD_INDEX);
            }
            currentState[metadata.getIndex()] = new Timestamp(System.currentTimeMillis());
            engaged = true;
        }
        return engaged;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        boolean engaged = false;
        MetaReaderService mrs = ContextUtil.getMRS();
        for (AnnotationMetadata metadata : mrs.getAnnotationMetadata(((Entity)entity).getEntityType(), InsertTimeHolder.class)) {
            if (!metadata.getName().equals(propertyNames[metadata.getIndex()])) {
                throw new IllegalStateException(INCORRECT_FIELD_INDEX);
            }
            state[metadata.getIndex()] = new Timestamp(System.currentTimeMillis());
            engaged = true;
        }
        for (AnnotationMetadata metadata : mrs.getAnnotationMetadata(((Entity)entity).getEntityType(), UserIdHolder.class)) {
            if (!metadata.getName().equals(propertyNames[metadata.getIndex()])) {
                throw new IllegalStateException(INCORRECT_FIELD_INDEX);
            }
            if (state[metadata.getIndex()] != null) continue;
            state[metadata.getIndex()] = ContextUtil.getSessionContext().getSecurityContext().getUserIdentity();
            engaged = true;
        }
        return engaged;
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (CoreUtil.isSystemLocked((Entity)((Entity)entity))) {
            throw new SystemProtectedEntryException();
        }
    }
}

