/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm.serial;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.mapper.CachingMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.lang.reflect.Field;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.oxm.xstream.XStreamMarshaller;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.serial.CurrentUserConverter;
import org.web4thejob.orm.serial.DateFormulaConverter;
import org.web4thejob.orm.serial.MyHibernateMapper;
import org.web4thejob.orm.serial.MyHibernateProxyConverter;

@Component
public class MyXStreamMarshaller
extends XStreamMarshaller {
    @Autowired
    private SessionFactory sessionFactory;

    private void customizeMappers(XStream xstream) {
        Converter reflectionConverter = xstream.getConverterLookup().lookupConverterForType(Entity.class);
        if (!ReflectionConverter.class.isInstance(reflectionConverter)) {
            throw new IllegalStateException("expected " + ReflectionConverter.class.getName() + " but got " + reflectionConverter.getClass().getName());
        }
        Field field = ReflectionUtils.findField(ReflectionConverter.class, (String)"mapper");
        ReflectionUtils.makeAccessible((Field)field);
        CachingMapper mapper = (CachingMapper)ReflectionUtils.getField((Field)field, (Object)reflectionConverter);
        mapper = new CachingMapper((Mapper)new MyHibernateMapper((MapperWrapper)mapper));
        ReflectionUtils.setField((Field)field, (Object)reflectionConverter, (Object)mapper);
    }

    protected void customizeXStream(XStream xstream) {
        this.customizeMappers(xstream);
        xstream.registerConverter((Converter)new MyHibernateProxyConverter());
        xstream.registerConverter((Converter)new DateFormulaConverter());
        xstream.registerConverter((Converter)new CurrentUserConverter());
        for (ClassMetadata meta : this.sessionFactory.getAllClassMetadata().values()) {
            for (String propertyName : meta.getPropertyNames()) {
                xstream.omitField(meta.getMappedClass(), propertyName);
            }
        }
    }
}

