/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.module;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.module.AbstractJoblet;
import org.web4thejob.module.H4Module;
import org.web4thejob.module.SystemJoblet;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.ORMUtil;
import org.web4thejob.orm.PanelDefinition;
import org.web4thejob.orm.Path;
import org.web4thejob.orm.parameter.EntityTypeEntityViewParameter;
import org.web4thejob.orm.parameter.EntityTypeListViewParameter;
import org.web4thejob.orm.parameter.EntityTypeQueryParameter;
import org.web4thejob.orm.parameter.LocationImagesRepoParameter;
import org.web4thejob.orm.parameter.PrinterCharsetParameter;
import org.web4thejob.orm.query.Condition;
import org.web4thejob.orm.query.Criterion;
import org.web4thejob.orm.query.OrderBy;
import org.web4thejob.orm.query.Query;
import org.web4thejob.orm.scheme.RenderElement;
import org.web4thejob.orm.scheme.RenderScheme;
import org.web4thejob.orm.scheme.RenderSchemeUtil;
import org.web4thejob.orm.scheme.SchemeType;
import org.web4thejob.security.AuthorizationPolicy;
import org.web4thejob.security.Identity;
import org.web4thejob.security.RoleIdentity;
import org.web4thejob.security.RoleMembers;
import org.web4thejob.security.UserIdentity;
import org.web4thejob.setting.SettingEnum;
import org.web4thejob.util.L10nMessages;
import org.web4thejob.web.panel.AuthorizationPolicyPanel;
import org.web4thejob.web.panel.BorderedLayoutPanel;
import org.web4thejob.web.panel.DesktopLayoutPanel;
import org.web4thejob.web.panel.FramePanel;
import org.web4thejob.web.panel.ListViewPanel;
import org.web4thejob.web.panel.MenuAuthorizationPanel;
import org.web4thejob.web.panel.ModuleInfoPanel;
import org.web4thejob.web.panel.Panel;
import org.web4thejob.web.panel.TabbedLayoutPanel;

@Component
public class SystemJobletImpl
extends AbstractJoblet
implements SystemJoblet {
    protected String getPropertiesName() {
        return H4Module.class.getSimpleName() + ".properties";
    }

    @Override
    public <E extends Exception> List<E> setup() {
        UserIdentity userIdentity = ContextUtil.getSecurityService().getAdministratorIdentity();
        HashMap<Object, String> beanIds = new HashMap<Object, String>();
        ListViewPanel panels = (ListViewPanel)ContextUtil.getDefaultPanel(ListViewPanel.class);
        panels.setTargetType(PanelDefinition.class);
        panels.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)ContextUtil.getMRS().getEntityMetadata(PanelDefinition.class).getFriendlyName()));
        beanIds.put(panels, ORMUtil.persistPanel((Panel)panels));
        ListViewPanel roles = (ListViewPanel)ContextUtil.getDefaultPanel(ListViewPanel.class);
        roles.setTargetType(RoleIdentity.class);
        roles.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)ContextUtil.getMRS().getEntityMetadata(RoleIdentity.class).getFriendlyName()));
        beanIds.put(roles, ORMUtil.persistPanel((Panel)roles));
        ListViewPanel users = (ListViewPanel)ContextUtil.getDefaultPanel(ListViewPanel.class);
        users.setTargetType(UserIdentity.class);
        users.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)ContextUtil.getMRS().getEntityMetadata(UserIdentity.class).getFriendlyName()));
        beanIds.put(users, ORMUtil.persistPanel((Panel)users));
        ListViewPanel policies = (ListViewPanel)ContextUtil.getDefaultPanel(ListViewPanel.class);
        policies.setTargetType(AuthorizationPolicy.class);
        policies.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)ContextUtil.getMRS().getEntityMetadata(AuthorizationPolicy.class).getFriendlyName()));
        beanIds.put(policies, ORMUtil.persistPanel((Panel)policies));
        FramePanel dashboard = (FramePanel)ContextUtil.getDefaultPanel(FramePanel.class);
        dashboard.setSettingValue(SettingEnum.TARGET_URL, (Serializable)((Object)"http://web4thejob.sourceforge.net/dashboard/index.php"));
        dashboard.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)"My Dashboard"));
        beanIds.put(dashboard, ORMUtil.persistPanel((Panel)dashboard));
        ListViewPanel entityViewParameters = (ListViewPanel)ContextUtil.getDefaultPanel(ListViewPanel.class);
        entityViewParameters.setTargetType(EntityTypeEntityViewParameter.class);
        entityViewParameters.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)ContextUtil.getMRS().getEntityMetadata(EntityTypeEntityViewParameter.class).getFriendlyName()));
        beanIds.put(entityViewParameters, ORMUtil.persistPanel((Panel)entityViewParameters));
        ListViewPanel listViewParameters = (ListViewPanel)ContextUtil.getDefaultPanel(ListViewPanel.class);
        listViewParameters.setTargetType(EntityTypeListViewParameter.class);
        listViewParameters.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)ContextUtil.getMRS().getEntityMetadata(EntityTypeListViewParameter.class).getFriendlyName()));
        beanIds.put(listViewParameters, ORMUtil.persistPanel((Panel)listViewParameters));
        ListViewPanel queryParameters = (ListViewPanel)ContextUtil.getDefaultPanel(ListViewPanel.class);
        queryParameters.setTargetType(EntityTypeQueryParameter.class);
        queryParameters.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)ContextUtil.getMRS().getEntityMetadata(EntityTypeQueryParameter.class).getFriendlyName()));
        beanIds.put(queryParameters, ORMUtil.persistPanel((Panel)queryParameters));
        ListViewPanel charsetParameters = (ListViewPanel)ContextUtil.getDefaultPanel(ListViewPanel.class);
        charsetParameters.setTargetType(PrinterCharsetParameter.class);
        charsetParameters.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)ContextUtil.getMRS().getEntityMetadata(PrinterCharsetParameter.class).getFriendlyName()));
        beanIds.put(charsetParameters, ORMUtil.persistPanel((Panel)charsetParameters));
        ListViewPanel imageRepoParameters = (ListViewPanel)ContextUtil.getDefaultPanel(ListViewPanel.class);
        imageRepoParameters.setTargetType(LocationImagesRepoParameter.class);
        imageRepoParameters.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)ContextUtil.getMRS().getEntityMetadata(LocationImagesRepoParameter.class).getFriendlyName()));
        beanIds.put(imageRepoParameters, ORMUtil.persistPanel((Panel)imageRepoParameters));
        ListViewPanel renderSchemes = (ListViewPanel)ContextUtil.getDefaultPanel(ListViewPanel.class);
        renderSchemes.setTargetType(RenderScheme.class);
        renderSchemes.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)ContextUtil.getMRS().getEntityMetadata(RenderScheme.class).getFriendlyName()));
        beanIds.put(renderSchemes, ORMUtil.persistPanel((Panel)renderSchemes));
        ListViewPanel queries = (ListViewPanel)ContextUtil.getDefaultPanel(ListViewPanel.class);
        queries.setTargetType(Query.class);
        queries.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)ContextUtil.getMRS().getEntityMetadata(Query.class).getFriendlyName()));
        beanIds.put(queries, ORMUtil.persistPanel((Panel)queries));
        ModuleInfoPanel moduleInfoPanel = (ModuleInfoPanel)ContextUtil.getDefaultPanel(ModuleInfoPanel.class);
        moduleInfoPanel.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)moduleInfoPanel.toString()));
        beanIds.put(moduleInfoPanel, ORMUtil.persistPanel((Panel)moduleInfoPanel));
        ListViewPanel members = (ListViewPanel)ContextUtil.getDefaultPanel(ListViewPanel.class);
        members.setTargetType(RoleMembers.class);
        members.setMasterType(UserIdentity.class);
        members.setBindProperty("user");
        members.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)ContextUtil.getMRS().getEntityMetadata(RoleMembers.class).getFriendlyName()));
        RenderScheme scheme = RenderSchemeUtil.createDefaultRenderScheme(RoleMembers.class, (SchemeType)SchemeType.LIST_SCHEME);
        scheme.setName(scheme.getName() + "\\user bound");
        scheme.getElements().clear();
        RenderElement renderElement = scheme.addElement(ContextUtil.getMRS().getPropertyPath(RoleMembers.class, new Path("role")));
        renderElement.setFriendlyName(ContextUtil.getMRS().getEntityMetadata(RoleIdentity.class).getFriendlyName());
        renderElement = scheme.addElement(ContextUtil.getMRS().getPropertyPath(RoleMembers.class, new String[]{"role", "authorizationPolicy"}));
        renderElement.setFriendlyName(ContextUtil.getMRS().getEntityMetadata(AuthorizationPolicy.class).getFriendlyName());
        ContextUtil.getDWS().save((Entity)scheme);
        members.setSettingValue(SettingEnum.RENDER_SCHEME_FOR_VIEW, (Serializable)((Object)scheme.getName()));
        ListViewPanel elements = (ListViewPanel)ContextUtil.getDefaultPanel(ListViewPanel.class);
        elements.setTargetType(RenderElement.class);
        elements.setMasterType(RenderScheme.class);
        elements.setBindProperty("renderScheme");
        elements.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)ContextUtil.getMRS().getEntityMetadata(RenderElement.class).getFriendlyName()));
        scheme = RenderSchemeUtil.createDefaultRenderScheme(RenderElement.class, (SchemeType)SchemeType.LIST_SCHEME, (String[])new String[]{"renderScheme"});
        scheme.setName(scheme.getName() + "\\scheme bound");
        ContextUtil.getDWS().save((Entity)scheme);
        elements.setSettingValue(SettingEnum.RENDER_SCHEME_FOR_VIEW, (Serializable)((Object)scheme.getName()));
        ListViewPanel criteria = (ListViewPanel)ContextUtil.getDefaultPanel(ListViewPanel.class);
        criteria.setTargetType(Criterion.class);
        criteria.setMasterType(Query.class);
        criteria.setBindProperty("query");
        criteria.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)ContextUtil.getMRS().getEntityMetadata(Criterion.class).getFriendlyName()));
        scheme = RenderSchemeUtil.createDefaultRenderScheme(Criterion.class, (SchemeType)SchemeType.LIST_SCHEME, (String[])new String[]{"query"});
        scheme.setName(scheme.getName() + "\\query bound");
        ContextUtil.getDWS().save((Entity)scheme);
        criteria.setSettingValue(SettingEnum.RENDER_SCHEME_FOR_VIEW, (Serializable)((Object)scheme.getName()));
        ListViewPanel orderings = (ListViewPanel)ContextUtil.getDefaultPanel(ListViewPanel.class);
        orderings.setTargetType(OrderBy.class);
        orderings.setMasterType(Query.class);
        orderings.setBindProperty("query");
        orderings.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)ContextUtil.getMRS().getEntityMetadata(OrderBy.class).getFriendlyName()));
        scheme = RenderSchemeUtil.createDefaultRenderScheme(OrderBy.class, (SchemeType)SchemeType.LIST_SCHEME, (String[])new String[]{"query"});
        scheme.setName(scheme.getName() + "\\query bound");
        ContextUtil.getDWS().save((Entity)scheme);
        orderings.setSettingValue(SettingEnum.RENDER_SCHEME_FOR_VIEW, (Serializable)((Object)scheme.getName()));
        ContextUtil.getSessionContext().refresh();
        BorderedLayoutPanel userRoles = (BorderedLayoutPanel)ContextUtil.getDefaultPanel(BorderedLayoutPanel.class);
        userRoles.setCenter(ContextUtil.getPanel((String)((String)beanIds.get(users))));
        userRoles.setSouth((Panel)members);
        userRoles.setSettingValue(SettingEnum.NORTH_ENABLED, (Serializable)Boolean.valueOf(false));
        userRoles.setSettingValue(SettingEnum.EAST_ENABLED, (Serializable)Boolean.valueOf(false));
        userRoles.setSettingValue(SettingEnum.WEST_ENABLED, (Serializable)Boolean.valueOf(false));
        userRoles.setSettingValue(SettingEnum.CENTER_ENABLED, (Serializable)Boolean.valueOf(true));
        userRoles.setSettingValue(SettingEnum.SOUTH_ENABLED, (Serializable)Boolean.valueOf(true));
        userRoles.setSettingValue(SettingEnum.SOUTH_COLLAPSIBLE, (Serializable)Boolean.valueOf(true));
        userRoles.setSettingValue(SettingEnum.SOUTH_SPLITTABLE, (Serializable)Boolean.valueOf(true));
        userRoles.setSettingValue(SettingEnum.SOUTH_MERGE_COMMANDS, (Serializable)Boolean.valueOf(false));
        userRoles.setSettingValue(SettingEnum.SOUTH_HEIGHT, (Serializable)((Object)"50%"));
        userRoles.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)(users.toString() + " & " + members.toString())));
        userRoles.render();
        beanIds.put(userRoles, ORMUtil.persistPanel((Panel)userRoles));
        BorderedLayoutPanel schemeElements = (BorderedLayoutPanel)ContextUtil.getDefaultPanel(BorderedLayoutPanel.class);
        schemeElements.setCenter(ContextUtil.getPanel((String)((String)beanIds.get(renderSchemes))));
        schemeElements.setSouth((Panel)elements);
        schemeElements.setSettingValue(SettingEnum.NORTH_ENABLED, (Serializable)Boolean.valueOf(false));
        schemeElements.setSettingValue(SettingEnum.EAST_ENABLED, (Serializable)Boolean.valueOf(false));
        schemeElements.setSettingValue(SettingEnum.WEST_ENABLED, (Serializable)Boolean.valueOf(false));
        schemeElements.setSettingValue(SettingEnum.CENTER_ENABLED, (Serializable)Boolean.valueOf(true));
        schemeElements.setSettingValue(SettingEnum.SOUTH_ENABLED, (Serializable)Boolean.valueOf(true));
        schemeElements.setSettingValue(SettingEnum.SOUTH_COLLAPSIBLE, (Serializable)Boolean.valueOf(true));
        schemeElements.setSettingValue(SettingEnum.SOUTH_SPLITTABLE, (Serializable)Boolean.valueOf(true));
        schemeElements.setSettingValue(SettingEnum.SOUTH_MERGE_COMMANDS, (Serializable)Boolean.valueOf(false));
        schemeElements.setSettingValue(SettingEnum.SOUTH_HEIGHT, (Serializable)((Object)"50%"));
        schemeElements.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)renderSchemes.toString()));
        schemeElements.render();
        beanIds.put(schemeElements, ORMUtil.persistPanel((Panel)schemeElements));
        BorderedLayoutPanel queriesElements = (BorderedLayoutPanel)ContextUtil.getDefaultPanel(BorderedLayoutPanel.class);
        queriesElements.setCenter(ContextUtil.getPanel((String)((String)beanIds.get(queries))));
        TabbedLayoutPanel tabbedLayoutPanel = (TabbedLayoutPanel)ContextUtil.getDefaultPanel(TabbedLayoutPanel.class);
        tabbedLayoutPanel.setSettingValue(SettingEnum.DISABLE_DYNAMIC_TAB_TITLE, (Serializable)Boolean.valueOf(true));
        tabbedLayoutPanel.getSubpanels().add((Object)criteria);
        tabbedLayoutPanel.getSubpanels().add((Object)orderings);
        tabbedLayoutPanel.setSelectedIndex(0);
        queriesElements.setSouth((Panel)tabbedLayoutPanel);
        queriesElements.setSettingValue(SettingEnum.NORTH_ENABLED, (Serializable)Boolean.valueOf(false));
        queriesElements.setSettingValue(SettingEnum.EAST_ENABLED, (Serializable)Boolean.valueOf(false));
        queriesElements.setSettingValue(SettingEnum.WEST_ENABLED, (Serializable)Boolean.valueOf(false));
        queriesElements.setSettingValue(SettingEnum.CENTER_ENABLED, (Serializable)Boolean.valueOf(true));
        queriesElements.setSettingValue(SettingEnum.SOUTH_ENABLED, (Serializable)Boolean.valueOf(true));
        queriesElements.setSettingValue(SettingEnum.SOUTH_COLLAPSIBLE, (Serializable)Boolean.valueOf(true));
        queriesElements.setSettingValue(SettingEnum.SOUTH_SPLITTABLE, (Serializable)Boolean.valueOf(true));
        queriesElements.setSettingValue(SettingEnum.SOUTH_MERGE_COMMANDS, (Serializable)Boolean.valueOf(false));
        queriesElements.setSettingValue(SettingEnum.SOUTH_HEIGHT, (Serializable)((Object)"50%"));
        queriesElements.setSettingValue(SettingEnum.PANEL_NAME, (Serializable)((Object)queries.toString()));
        queriesElements.render();
        beanIds.put(queriesElements, ORMUtil.persistPanel((Panel)queriesElements));
        DesktopLayoutPanel desktop = (DesktopLayoutPanel)ContextUtil.getDefaultPanel(DesktopLayoutPanel.class);
        desktop.addTab((Panel)dashboard);
        desktop.render();
        Query adminRoleQuery = ContextUtil.getEntityFactory().buildQuery(RoleIdentity.class);
        adminRoleQuery.addCriterion(new Path("code"), Condition.EQ, (Object)"ADMINISTRATOR");
        beanIds.put(desktop, ORMUtil.persistPanel((Panel)desktop, (String)"Administrator's default Desktop", null, (Identity)((Identity)ContextUtil.getDRS().findUniqueByQuery(adminRoleQuery))));
        ContextUtil.getSessionContext().refresh();
        AuthorizationPolicyPanel policyPanel = (AuthorizationPolicyPanel)ContextUtil.getDefaultPanel(AuthorizationPolicyPanel.class);
        policyPanel.render();
        MenuAuthorizationPanel menuAuthorizationPanel = policyPanel.getMenuAuthorizationPanel();
        Object rootItem = menuAuthorizationPanel.getRootItem();
        Object panelsMenu = menuAuthorizationPanel.renderAddedMenu(rootItem, L10nMessages.L10N_NAME_DEFAULT_PANELS_MENU.toString());
        menuAuthorizationPanel.renderAddedPanel(panelsMenu, ContextUtil.getPanel((String)((String)beanIds.get(dashboard))));
        menuAuthorizationPanel.renderAddedPanel(panelsMenu, ContextUtil.getPanel((String)((String)beanIds.get(panels))));
        menuAuthorizationPanel.renderAddedPanel(panelsMenu, ContextUtil.getPanel((String)((String)beanIds.get(schemeElements))));
        menuAuthorizationPanel.renderAddedPanel(panelsMenu, ContextUtil.getPanel((String)((String)beanIds.get(queriesElements))));
        menuAuthorizationPanel.renderAddedPanel(panelsMenu, ContextUtil.getPanel((String)((String)beanIds.get(moduleInfoPanel))));
        Object securityMenu = menuAuthorizationPanel.renderAddedMenu(rootItem, L10nMessages.L10N_NAME_DEFAULT_SECURITY_MENU.toString());
        menuAuthorizationPanel.renderAddedPanel(securityMenu, ContextUtil.getPanel((String)((String)beanIds.get(userRoles))));
        menuAuthorizationPanel.renderAddedPanel(securityMenu, ContextUtil.getPanel((String)((String)beanIds.get(policies))));
        menuAuthorizationPanel.renderAddedPanel(securityMenu, ContextUtil.getPanel((String)((String)beanIds.get(roles))));
        Object paramsMenu = menuAuthorizationPanel.renderAddedMenu(rootItem, L10nMessages.L10N_NAME_DEFAULT_PARAMETERS_MENU.toString());
        menuAuthorizationPanel.renderAddedPanel(paramsMenu, ContextUtil.getPanel((String)((String)beanIds.get(entityViewParameters))));
        menuAuthorizationPanel.renderAddedPanel(paramsMenu, ContextUtil.getPanel((String)((String)beanIds.get(listViewParameters))));
        menuAuthorizationPanel.renderAddedPanel(paramsMenu, ContextUtil.getPanel((String)((String)beanIds.get(queryParameters))));
        menuAuthorizationPanel.renderAddedPanel(paramsMenu, ContextUtil.getPanel((String)((String)beanIds.get(charsetParameters))));
        menuAuthorizationPanel.renderAddedPanel(paramsMenu, ContextUtil.getPanel((String)((String)beanIds.get(imageRepoParameters))));
        AuthorizationPolicy authorizationPolicy = ContextUtil.getEntityFactory().buildAuthorizationPolicy();
        authorizationPolicy.setName(L10nMessages.L10N_NAME_DEFAULT_ADMINISTRATORS_MENU.toString());
        authorizationPolicy.setDefinition(policyPanel.getDefinition());
        ContextUtil.getDWS().save((Entity)authorizationPolicy);
        RoleIdentity role = ((RoleMembers)userIdentity.getRoles().iterator().next()).getRole();
        role.setAuthorizationPolicy(authorizationPolicy);
        ContextUtil.getDWS().save((Entity)role);
        role = ContextUtil.getEntityFactory().buildRoleIdentity();
        role.setCode("ANYONE");
        role.setIndex(1000);
        ContextUtil.getDWS().save((Entity)role);
        RoleMembers roleMembers = ContextUtil.getEntityFactory().buildRoleMembers();
        roleMembers.setRole(role);
        roleMembers.setUser(userIdentity);
        ContextUtil.getDWS().save((Entity)roleMembers);
        Query query = ContextUtil.getEntityFactory().buildQuery(Identity.class);
        query.setName("by code");
        query.setCached(true);
        query.addOrderBy(new Path("code"));
        ContextUtil.getDWS().save((Entity)query);
        EntityTypeQueryParameter entityTypeQueryParameter = (EntityTypeQueryParameter)ContextUtil.getEntityFactory().buildParameter(EntityTypeQueryParameter.class);
        entityTypeQueryParameter.setOwner((Identity)role);
        entityTypeQueryParameter.setKey(Identity.class.getCanonicalName());
        entityTypeQueryParameter.setValue(Long.valueOf(query.getId()).toString());
        ContextUtil.getDWS().save((Entity)entityTypeQueryParameter);
        return super.setup();
    }

    public String getName() {
        return "System Joblet";
    }

    public String getProjectUrl() {
        return "http://wiki.web4thejob.org/miscel/glossary/system_joblet";
    }

    public int getOrdinal() {
        return 5;
    }

    public List<Resource> getResources() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            for (Resource resource : resolver.getResources("classpath*:org/web4thejob/orm/**/*.hbm.xml")) {
                if (resource.getFilename().equals("AuxiliaryDatabaseObjects.hbm.xml")) continue;
                resources.add(resource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return resources;
    }

    public String getBasePackage() {
        return "org.web4thejob.orm";
    }

    public boolean isInstalled() {
        Properties datasource = new Properties();
        try {
            datasource.load(new ClassPathResource("/org/web4thejob/conf/datasource.properties").getInputStream());
        }
        catch (IOException e) {
            return false;
        }
        return StringUtils.hasText((String)datasource.getProperty("datasource.installed"));
    }

    public String[] getSchemas() {
        return new String[]{"w4tj"};
    }
}

