/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.web4thejob.orm.AnnotationMetadata;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.MetaUtil;

class AnnotationMetadataImpl<A extends Annotation>
implements AnnotationMetadata<A> {
    private final Class<? extends Entity> entityType;
    private final int hibernateIndex;
    private final Field field;
    private final A annotation;

    public AnnotationMetadataImpl(Class<? extends Entity> entityType, Field field, A annotation) {
        this.entityType = entityType;
        this.field = field;
        this.annotation = annotation;
        this.hibernateIndex = MetaUtil.getHibernatePropertyIndex(entityType.getName(), field.getName());
    }

    public Class<? extends Entity> getEntityType() {
        return this.entityType;
    }

    public int getIndex() {
        return this.hibernateIndex;
    }

    public Field getField() {
        return this.field;
    }

    public A getAnnotation() {
        return this.annotation;
    }

    public String getName() {
        return this.field.getName();
    }
}

