/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.EntityMetadata;
import org.web4thejob.orm.scheme.RenderScheme;
import org.web4thejob.orm.scheme.RenderSchemeUtil;
import org.web4thejob.orm.scheme.SchemeType;
import org.web4thejob.security.Identity;
import org.web4thejob.util.CoreUtil;

class MappingInitializer
implements ApplicationListener<ContextRefreshedEvent> {
    MappingInitializer() {
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getParent() != null) {
            return;
        }
        ContextUtil.getMRS().refreshMetaCache();
        if (ContextUtil.getMRS().getEntityMetadata(RenderScheme.class) != null) {
            this.createDefaultRenderSchemes(SchemeType.LIST_SCHEME);
            this.createDefaultRenderSchemes(SchemeType.ENTITY_SCHEME);
        }
    }

    private void createDefaultRenderSchemes(SchemeType schemeType) {
        for (EntityMetadata entityMetadata : ContextUtil.getMRS().getEntityMetadatas()) {
            RenderScheme renderScheme = RenderSchemeUtil.getDefaultRenderScheme((Class)entityMetadata.getEntityType(), (SchemeType)schemeType);
            if (renderScheme == null) {
                renderScheme = RenderSchemeUtil.createDefaultRenderScheme((Class)entityMetadata.getEntityType(), (SchemeType)schemeType);
                renderScheme.setOwner((Identity)ContextUtil.getSecurityService().getAdministratorIdentity());
                ContextUtil.getDWS().save((Entity)renderScheme);
            }
            CoreUtil.addSystemLock((Entity)renderScheme);
        }
    }
}

