/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.EntityNameResolver;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.util.ReflectionUtils;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.AnnotationMetadata;
import org.web4thejob.orm.AnnotationMetadataImpl;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.EntityMetadata;
import org.web4thejob.orm.EntityMetadataImpl;
import org.web4thejob.orm.EntityNameResolverImpl;
import org.web4thejob.orm.MetaReaderService;
import org.web4thejob.orm.Path;
import org.web4thejob.orm.PathMetadata;
import org.web4thejob.orm.PathMetadataImpl;
import org.web4thejob.orm.PropertyMetadata;
import org.web4thejob.orm.annotation.ColorHolder;
import org.web4thejob.orm.annotation.ControllerHolder;
import org.web4thejob.orm.annotation.DefaultHolder;
import org.web4thejob.orm.annotation.EmailHolder;
import org.web4thejob.orm.annotation.Encrypted;
import org.web4thejob.orm.annotation.EntityTypeHolder;
import org.web4thejob.orm.annotation.HtmlHolder;
import org.web4thejob.orm.annotation.ImageHolder;
import org.web4thejob.orm.annotation.InsertTimeHolder;
import org.web4thejob.orm.annotation.MediaHolder;
import org.web4thejob.orm.annotation.PanelHolder;
import org.web4thejob.orm.annotation.PropertyEditor;
import org.web4thejob.orm.annotation.PropertyViewer;
import org.web4thejob.orm.annotation.QueryHolder;
import org.web4thejob.orm.annotation.StatusHolder;
import org.web4thejob.orm.annotation.UpdateTimeHolder;
import org.web4thejob.orm.annotation.UrlHolder;
import org.web4thejob.orm.annotation.UserIdHolder;
import org.web4thejob.orm.query.Condition;
import org.web4thejob.orm.query.Query;
import org.web4thejob.security.RoleIdentity;
import org.web4thejob.security.RoleMembers;
import org.web4thejob.security.UserIdentity;
import org.web4thejob.util.CoreUtil;

class MetaReaderServiceImpl
implements MetaReaderService {
    static final Map<String, EntityMetadata> metaCache = new HashMap<String, EntityMetadata>();
    static final Map<String, Map<String, Map<String, AnnotationMetadata<? extends Annotation>>>> annoCache = new HashMap<String, Map<String, Map<String, AnnotationMetadata<? extends Annotation>>>>();
    @Autowired
    private SessionFactory sessionFactory;

    MetaReaderServiceImpl() {
    }

    public <E extends Entity> E deproxyEntity(E entity) {
        final E proxy = entity;
        if (proxy instanceof HibernateProxy) {
            if (((HibernateProxy)proxy).getHibernateLazyInitializer().isUninitialized()) {
                Entity impl = (Entity)ContextUtil.getTransactionWrapper().execute(new TransactionCallback<E>(){

                    public E doInTransaction(TransactionStatus status) {
                        LazyInitializer lazy = ((HibernateProxy)proxy).getHibernateLazyInitializer();
                        lazy.setSession((SessionImplementor)MetaReaderServiceImpl.this.sessionFactory.getCurrentSession());
                        lazy.initialize();
                        Object impl = lazy.getImplementation();
                        lazy.unsetSession();
                        return (Entity)impl;
                    }
                });
                return (E)impl;
            }
            return (E)((Entity)((HibernateProxy)proxy).getHibernateLazyInitializer().getImplementation());
        }
        return entity;
    }

    public <E extends Entity, A extends Annotation> Collection<AnnotationMetadata<A>> getAnnotationMetadata(Class<E> entityType, Class<A> annotationType) {
        Map<String, Map<String, AnnotationMetadata<? extends Annotation>>> map = annoCache.get(entityType.getName());
        if (map != null && map.containsKey(annotationType.getName())) {
            ArrayList<AnnotationMetadata<A>> metadatas = new ArrayList<AnnotationMetadata<A>>();
            for (AnnotationMetadata<? extends Annotation> a : map.get(annotationType.getName()).values()) {
                metadatas.add(a);
            }
            return metadatas;
        }
        return Collections.emptyList();
    }

    public EntityMetadata getEntityMetadata(Class<? extends Entity> entityType) {
        return this.getEntityMetadata(entityType.getName());
    }

    public EntityMetadata getEntityMetadata(String entityType) {
        return metaCache.get(entityType);
    }

    public PropertyMetadata getPropertyMetadata(Class<? extends Entity> entityType, String property) {
        return this.getEntityMetadata(entityType).getPropertyMetadata(property);
    }

    public PropertyMetadata getPropertyMetadata(String entityType, String property) {
        return this.getEntityMetadata(entityType).getPropertyMetadata(property);
    }

    public PathMetadata getPropertyPath(Class<? extends Entity> entityType, Path path) {
        return new PathMetadataImpl(entityType, path);
    }

    public PathMetadata getPropertyPath(Class<? extends Entity> entityType, String[] path) {
        return new PathMetadataImpl(entityType, path);
    }

    public PathMetadata getPropertyPath(Class<? extends Entity> entityType, List<PropertyMetadata> path) {
        String[] steps = new String[path.size()];
        int index = 0;
        for (PropertyMetadata item : path) {
            steps[index] = item.getName();
            ++index;
        }
        return new PathMetadataImpl(entityType, steps);
    }

    public PathMetadata getPropertyPath(PropertyMetadata propertyMetadata) {
        return new PathMetadataImpl((Class<? extends Entity>)propertyMetadata.getEntityMetadata().getEntityType(), new Path(propertyMetadata.getName()));
    }

    public <E extends Entity> E newInstance(Class<? extends Entity> entityType) {
        try {
            if (entityType.isInterface()) {
                entityType = this.getEntityMetadata(entityType).getMappedClass();
            }
            return (E)((Entity)ReflectHelper.getDefaultConstructor(entityType).newInstance(null));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void refreshMetaCache() {
        ((SessionFactoryImpl)this.sessionFactory).registerEntityNameResolver((EntityNameResolver)EntityNameResolverImpl.INSTANCE);
        annoCache.clear();
        for (ClassMetadata classMetadata : this.sessionFactory.getAllClassMetadata().values()) {
            AnnotationReader reader = new AnnotationReader(classMetadata.getEntityName());
            ReflectionUtils.doWithFields((Class)classMetadata.getMappedClass(), (ReflectionUtils.FieldCallback)reader);
            if (reader.map.size() <= 0) continue;
            annoCache.put(classMetadata.getEntityName(), reader.map);
        }
        metaCache.clear();
        for (ClassMetadata classMetadata : this.sessionFactory.getAllClassMetadata().values()) {
            if (metaCache.containsKey(classMetadata.getEntityName())) continue;
            metaCache.put(classMetadata.getEntityName(), new EntityMetadataImpl(classMetadata));
        }
        for (EntityMetadata entityMetadata : metaCache.values()) {
            ((EntityMetadataImpl)entityMetadata).initUniqueKeyConstraints();
        }
        this.ensureAdministratorExists();
    }

    public Collection<EntityMetadata> getEntityMetadatas() {
        ArrayList<EntityMetadata> metadatas = new ArrayList<EntityMetadata>(metaCache.values());
        Collections.sort(metadatas, new Comparator<EntityMetadata>(){

            @Override
            public int compare(EntityMetadata o1, EntityMetadata o2) {
                return (o1.getSchema() + o1.getFriendlyName()).compareTo(o2.getSchema() + o2.getFriendlyName());
            }
        });
        return Collections.unmodifiableCollection(metadatas);
    }

    private void ensureAdministratorExists() {
        UserIdentity userAdmin = ContextUtil.getSecurityService().getAdministratorIdentity();
        Query query = ContextUtil.getEntityFactory().buildQuery(RoleIdentity.class);
        query.addCriterion(new Path("code"), Condition.EQ, (Object)"ADMINISTRATOR");
        RoleIdentity roleAdmin = (RoleIdentity)ContextUtil.getDRS().findUniqueByQuery(query);
        if (roleAdmin == null) {
            roleAdmin = ContextUtil.getEntityFactory().buildRoleIdentity();
            roleAdmin.setCode("ADMINISTRATOR");
            ContextUtil.getDWS().save((Entity)roleAdmin);
        }
        query = ContextUtil.getEntityFactory().buildQuery(RoleMembers.class);
        query.addCriterion(new Path("role"), Condition.EQ, (Object)roleAdmin);
        query.addCriterion(new Path("user"), Condition.EQ, (Object)userAdmin);
        RoleMembers adminMembers = (RoleMembers)ContextUtil.getDRS().findUniqueByQuery(query);
        if (adminMembers == null) {
            adminMembers = ContextUtil.getEntityFactory().buildRoleMembers();
            adminMembers.setRole(roleAdmin);
            adminMembers.setUser(userAdmin);
            ContextUtil.getDWS().save((Entity)adminMembers);
        }
        CoreUtil.addSystemLock((Entity)userAdmin);
        CoreUtil.addSystemLock((Entity)roleAdmin);
        CoreUtil.addSystemLock((Entity)adminMembers);
    }

    private Class<? extends Entity> getEntityType(String entityName) {
        try {
            return Class.forName(entityName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(entityName + " is not a valid Entity implementation");
        }
    }

    private class AnnotationReader
    implements ReflectionUtils.FieldCallback {
        public final Map<String, Map<String, AnnotationMetadata<? extends Annotation>>> map = new HashMap<String, Map<String, AnnotationMetadata<? extends Annotation>>>();
        private final String declaringType;

        public AnnotationReader(String declaringType) {
            this.declaringType = declaringType;
        }

        private <A extends Annotation> void appendMetadata(Class<A> annotationType, AnnotationMetadata<A> metadata) {
            if (!this.map.containsKey(annotationType.getName())) {
                this.map.put(annotationType.getName(), new HashMap());
            }
            this.map.get(annotationType.getName()).put(metadata.getName(), metadata);
        }

        public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
            if (field.isAnnotationPresent(InsertTimeHolder.class)) {
                this.appendMetadata(InsertTimeHolder.class, new AnnotationMetadataImpl<InsertTimeHolder>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(InsertTimeHolder.class)));
            }
            if (field.isAnnotationPresent(UpdateTimeHolder.class)) {
                this.appendMetadata(UpdateTimeHolder.class, new AnnotationMetadataImpl<UpdateTimeHolder>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(UpdateTimeHolder.class)));
            }
            if (field.isAnnotationPresent(StatusHolder.class)) {
                this.appendMetadata(StatusHolder.class, new AnnotationMetadataImpl<StatusHolder>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(StatusHolder.class)));
            }
            if (field.isAnnotationPresent(PropertyViewer.class)) {
                this.appendMetadata(PropertyViewer.class, new AnnotationMetadataImpl<PropertyViewer>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(PropertyViewer.class)));
            }
            if (field.isAnnotationPresent(PropertyEditor.class)) {
                this.appendMetadata(PropertyEditor.class, new AnnotationMetadataImpl<PropertyEditor>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(PropertyEditor.class)));
            }
            if (field.isAnnotationPresent(Encrypted.class)) {
                this.appendMetadata(Encrypted.class, new AnnotationMetadataImpl<Encrypted>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(Encrypted.class)));
            }
            if (field.isAnnotationPresent(UserIdHolder.class)) {
                this.appendMetadata(UserIdHolder.class, new AnnotationMetadataImpl<UserIdHolder>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(UserIdHolder.class)));
            }
            if (field.isAnnotationPresent(HtmlHolder.class)) {
                this.appendMetadata(HtmlHolder.class, new AnnotationMetadataImpl<HtmlHolder>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(HtmlHolder.class)));
            }
            if (field.isAnnotationPresent(EmailHolder.class)) {
                this.appendMetadata(EmailHolder.class, new AnnotationMetadataImpl<EmailHolder>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(EmailHolder.class)));
            }
            if (field.isAnnotationPresent(DefaultHolder.class)) {
                this.appendMetadata(DefaultHolder.class, new AnnotationMetadataImpl<DefaultHolder>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(DefaultHolder.class)));
            }
            if (field.isAnnotationPresent(ColorHolder.class)) {
                this.appendMetadata(ColorHolder.class, new AnnotationMetadataImpl<ColorHolder>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(ColorHolder.class)));
            }
            if (field.isAnnotationPresent(UrlHolder.class)) {
                this.appendMetadata(UrlHolder.class, new AnnotationMetadataImpl<UrlHolder>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(UrlHolder.class)));
            }
            if (field.isAnnotationPresent(MediaHolder.class)) {
                this.appendMetadata(MediaHolder.class, new AnnotationMetadataImpl<MediaHolder>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(MediaHolder.class)));
            }
            if (field.isAnnotationPresent(ImageHolder.class)) {
                this.appendMetadata(ImageHolder.class, new AnnotationMetadataImpl<ImageHolder>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(ImageHolder.class)));
            }
            if (field.isAnnotationPresent(EntityTypeHolder.class)) {
                this.appendMetadata(EntityTypeHolder.class, new AnnotationMetadataImpl<EntityTypeHolder>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(EntityTypeHolder.class)));
            }
            if (field.isAnnotationPresent(PanelHolder.class)) {
                this.appendMetadata(PanelHolder.class, new AnnotationMetadataImpl<PanelHolder>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(PanelHolder.class)));
            }
            if (field.isAnnotationPresent(ControllerHolder.class)) {
                this.appendMetadata(ControllerHolder.class, new AnnotationMetadataImpl<ControllerHolder>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(ControllerHolder.class)));
            }
            if (field.isAnnotationPresent(QueryHolder.class)) {
                this.appendMetadata(QueryHolder.class, new AnnotationMetadataImpl<QueryHolder>(MetaReaderServiceImpl.this.getEntityType(this.declaringType), field, field.getAnnotation(QueryHolder.class)));
            }
        }
    }
}

