/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.AssociationType;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.CurrencyType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.MaterializedBlobType;
import org.hibernate.type.MaterializedClobType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.ShortType;
import org.hibernate.type.TextType;
import org.hibernate.type.TimeType;
import org.hibernate.type.TimestampType;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.beans.PropertyAccessorFactory;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.AnnotationMetadata;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.EntityMetadata;
import org.web4thejob.orm.EntityMetadataImpl;
import org.web4thejob.orm.MetaReaderServiceImpl;
import org.web4thejob.orm.MetaUtil;
import org.web4thejob.orm.PropertyMetadata;
import org.web4thejob.orm.SubclassPropertyMetadataImpl;

class PropertyMetadataImpl
implements PropertyMetadata,
Comparable<PropertyMetadata> {
    private static final String META_FRIENDLY_NAME = "friendlyName";
    private static final String META_INDEX = "index";
    private static final String META_DISABLE_USER_INSERT = "disable-user-insert";
    private static final String META_DISABLE_USER_UPDATE = "disable-user-update";
    private static final String META_DEFAULT_FORMAT = "default-format";
    private static final String META_DEFAULT_STYLE = "default-style";
    private static final String META_DEFAULT_ALIGN = "default-align";
    private static final String META_DEFAULT_WIDTH = "default-width";
    private static final String META_DEFAULT_HEIGHT = "default-height";
    private final EntityMetadataImpl entityMetadata;
    private final String associatedEntityName;
    private final Property property;
    private final int maxLength;
    private final int index;
    private final boolean disableUserInsert;
    private final boolean disableUserUpdate;
    private final boolean identifier;
    private final boolean identityIdentifier;
    private final boolean formula;
    private final String friendlyName;
    private final String format;
    private final String align;
    private final String style;
    private final String width;
    private final String height;
    private final Map<String, AnnotationMetadata<? extends Annotation>> annotations;

    public PropertyMetadataImpl(EntityMetadataImpl entityMetadata, String propertyName) {
        this(entityMetadata, propertyName, null);
    }

    protected PropertyMetadataImpl(EntityMetadataImpl entityMetadata, String propertyName, Class<? extends Entity> subclassAssociation) {
        this.entityMetadata = entityMetadata;
        this.property = entityMetadata.getPersistentClass().getProperty(propertyName);
        if (this.property.getType() instanceof AssociationType) {
            String tempName = ((AssociationType)this.property.getType()).getAssociatedEntityName((SessionFactoryImplementor)ContextUtil.getBean(SessionFactoryImplementor.class));
            if (subclassAssociation != null) {
                tempName = subclassAssociation.getCanonicalName();
            }
            this.associatedEntityName = tempName;
        } else {
            this.associatedEntityName = null;
        }
        int maxLength = 0;
        boolean hasFormula = false;
        Iterator iter = this.property.getColumnIterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof Column && ((Column)item).getLength() > 0) {
                maxLength += ((Column)item).getLength();
                continue;
            }
            if (!(item instanceof Formula)) continue;
            hasFormula = true;
        }
        this.formula = hasFormula;
        this.maxLength = maxLength;
        this.identifier = this.property.getName().equals(entityMetadata.getIdentifierName());
        this.annotations = this.getAnnotations();
        this.identityIdentifier = this.identifier && MetaUtil.isIdentityKey(entityMetadata.getPersistentClass().getIdentifier());
        this.friendlyName = MetaUtil.hasMetaAttribute(this.property, META_FRIENDLY_NAME) ? MetaUtil.getMetaAttribute(this.property, META_FRIENDLY_NAME) : this.property.getName();
        this.index = MetaUtil.hasMetaAttribute(this.property, META_INDEX) ? Integer.valueOf(MetaUtil.getMetaAttribute(this.property, META_INDEX)) : MetaUtil.getHibernatePropertyIndex(entityMetadata.getName(), this.property.getName());
        this.disableUserInsert = MetaUtil.hasMetaAttribute(this.property, META_DISABLE_USER_INSERT) ? Boolean.valueOf(MetaUtil.getMetaAttribute(this.property, META_DISABLE_USER_INSERT)) : false;
        this.disableUserUpdate = MetaUtil.hasMetaAttribute(this.property, META_DISABLE_USER_UPDATE) ? Boolean.valueOf(MetaUtil.getMetaAttribute(this.property, META_DISABLE_USER_UPDATE)) : false;
        this.format = MetaUtil.hasMetaAttribute(this.property, META_DEFAULT_FORMAT) ? MetaUtil.getMetaAttribute(this.property, META_DEFAULT_FORMAT) : this.buildDefaultPattern();
        this.style = MetaUtil.hasMetaAttribute(this.property, META_DEFAULT_STYLE) ? MetaUtil.getMetaAttribute(this.property, META_DEFAULT_STYLE) : null;
        this.align = MetaUtil.hasMetaAttribute(this.property, META_DEFAULT_ALIGN) ? MetaUtil.getMetaAttribute(this.property, META_DEFAULT_ALIGN) : this.buildDefaultAlign();
        this.width = MetaUtil.hasMetaAttribute(this.property, META_DEFAULT_WIDTH) ? MetaUtil.getMetaAttribute(this.property, META_DEFAULT_WIDTH) : null;
        this.height = MetaUtil.hasMetaAttribute(this.property, META_DEFAULT_HEIGHT) ? MetaUtil.getMetaAttribute(this.property, META_DEFAULT_HEIGHT) : null;
    }

    private Map<String, AnnotationMetadata<? extends Annotation>> getAnnotations() {
        HashMap<String, AnnotationMetadata<? extends Annotation>> propAnnotations = new HashMap<String, AnnotationMetadata<? extends Annotation>>();
        if (MetaReaderServiceImpl.annoCache.containsKey(this.entityMetadata.getName())) {
            for (String annotation : MetaReaderServiceImpl.annoCache.get(this.entityMetadata.getName()).keySet()) {
                if (!MetaReaderServiceImpl.annoCache.get(this.entityMetadata.getName()).get(annotation).containsKey(this.getName())) continue;
                propAnnotations.put(annotation, MetaReaderServiceImpl.annoCache.get(this.entityMetadata.getName()).get(annotation).get(this.getName()));
            }
        }
        if (propAnnotations.size() > 0) {
            return propAnnotations;
        }
        return Collections.emptyMap();
    }

    public String getName() {
        return this.property.getName();
    }

    private String buildDefaultPattern() {
        if (this.property.getType() instanceof LongType || this.property.getType() instanceof IntegerType || this.property.getType() instanceof ShortType || this.property.getType() instanceof BigIntegerType) {
            return "number,integer";
        }
        if (this.property.getType() instanceof DoubleType || this.property.getType() instanceof FloatType || this.property.getType() instanceof BigDecimalType) {
            return "number,#,##0.00";
        }
        if (this.property.getType() instanceof CurrencyType) {
            return "number,currency";
        }
        if (this.property.getType() instanceof DateType) {
            return "date";
        }
        if (this.property.getType() instanceof TimeType) {
            return "time";
        }
        if (this.property.getType() instanceof TimestampType) {
            return "date,long";
        }
        return null;
    }

    private String buildDefaultAlign() {
        if (Number.class.isAssignableFrom(this.getJavaType())) {
            return "right";
        }
        if (Date.class.isAssignableFrom(this.getJavaType())) {
            return "center";
        }
        if (String.class.isAssignableFrom(this.getJavaType()) && this.getMaxLength() > 0 && this.getMaxLength() <= 5) {
            return "center";
        }
        return null;
    }

    public Class<?> getJavaType() {
        return this.property.getType().getReturnedClass();
    }

    public String getAlign() {
        return this.align;
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    public String getFormat() {
        return this.format;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public int getIndex() {
        return this.index;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String getStyle() {
        return this.style;
    }

    public boolean isIdentifier() {
        return this.identifier;
    }

    public boolean isIdentityIdentifier() {
        return this.identityIdentifier;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.entityMetadata.getName()).append("|").append(this.getName());
        return sb.toString();
    }

    @Override
    public int compareTo(PropertyMetadata other) {
        Integer i2;
        Integer i1 = this.getIndex();
        int res = i1.compareTo(i2 = Integer.valueOf(other.getIndex()));
        if (res != 0) {
            return res;
        }
        return Integer.valueOf(this.hashCode()).compareTo(other.hashCode());
    }

    public <E extends Entity> void deproxyValue(E entity) {
        if (this.isProxyValue(entity)) {
            this.setValue(entity, this.getValue(entity));
        }
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        if (this.isAnnotatedWith(annotationType)) {
            return (A)this.annotations.get(annotationType.getName()).getAnnotation();
        }
        return null;
    }

    public EntityMetadata getAssociatedEntityMetadata() {
        if (this.associatedEntityName != null) {
            return ContextUtil.getMRS().getEntityMetadata(this.associatedEntityName);
        }
        return null;
    }

    public <T, E extends Entity> T getValue(E entity) {
        Object value;
        if (this.isOneToManyType()) {
            throw new RuntimeException("cannot call getValue for a Collection property");
        }
        if (entity instanceof HibernateProxy) {
            entity = ContextUtil.getMRS().deproxyEntity(entity);
        }
        if ((value = !this.isIdentifier() ? this.entityMetadata.getClassMetadata().getPropertyValue(entity, this.getName()) : PropertyAccessorFactory.forDirectFieldAccess(entity).getPropertyValue(this.getName())) != null && value instanceof HibernateProxy) {
            value = ContextUtil.getMRS().deproxyEntity((Entity)value);
        }
        return (T)value;
    }

    public boolean hasColumn(String name) {
        Iterator iter = this.property.getColumnIterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (!(item instanceof Selectable) || !((Selectable)item).getText().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasColumns() {
        return this.property.getColumnSpan() > 0;
    }

    public <A extends Annotation> boolean isAnnotatedWith(Class<A> annotationType) {
        return this.annotations.containsKey(annotationType.getName());
    }

    public boolean isAssociatedWith(PropertyMetadata propertyMetadata) {
        if (!this.isAssociationType() || !propertyMetadata.isAssociationType()) {
            return false;
        }
        if (!this.getAssociatedEntityMetadata().getEntityType().isAssignableFrom(propertyMetadata.getEntityMetadata().getEntityType())) {
            return false;
        }
        if (this.isOneToOneType() && propertyMetadata.isOneToOneType()) {
            return true;
        }
        if (!propertyMetadata.hasColumns()) {
            return propertyMetadata.isAssociatedWith((PropertyMetadata)this);
        }
        Joinable j = ((AssociationType)this.property.getType()).getAssociatedJoinable((SessionFactoryImplementor)ContextUtil.getBean(SessionFactoryImplementor.class));
        for (String p : j.getKeyColumnNames()) {
            if (!propertyMetadata.hasColumn(p.replace("\"", ""))) continue;
            return true;
        }
        return false;
    }

    public boolean isAssociationType() {
        return this.property.getType() instanceof AssociationType;
    }

    public boolean isSubclassType() {
        return false;
    }

    public boolean isBlobType() {
        return this.property.getType() instanceof MaterializedBlobType;
    }

    public boolean isClobType() {
        return this.property.getType() instanceof MaterializedClobType;
    }

    public boolean isTextType() {
        return this.property.getType() instanceof TextType;
    }

    public PropertyMetadata castForSubclass(Class<? extends Entity> subclass) {
        if (this.isAssociationType()) {
            for (Class subtype : this.getAssociatedEntityMetadata().getSubclasses()) {
                if (!subtype.equals(subclass)) continue;
                return new SubclassPropertyMetadataImpl(this.entityMetadata, subtype, this.getName());
            }
        }
        return null;
    }

    public boolean isCompositeType() {
        return this.property.getType() instanceof CompositeType;
    }

    public boolean isInsertable() {
        return !this.entityMetadata.isReadOnly() && this.property.isInsertable() && !this.disableUserInsert && !this.formula && !this.isIdentityIdentifier() && PropertyGeneration.NEVER == this.property.getGeneration();
    }

    public boolean isManyToOneType() {
        return this.property.getType() instanceof ManyToOneType;
    }

    public boolean isUniqueKeyWith(String propertyName) {
        if (this.getName().equals(propertyName)) {
            return false;
        }
        for (PersistentClass pc = this.entityMetadata.getPersistentClass(); pc != null; pc = pc.getSuperclass()) {
            Table table = pc.getTable();
            Iterator iterUK = table.getUniqueKeyIterator();
            while (iterUK.hasNext()) {
                UniqueKey uniqueKey = (UniqueKey)iterUK.next();
                if (uniqueKey.getColumnSpan() <= 1) continue;
                int totcols = 0;
                boolean keyMembers = true;
                for (PropertyMetadataImpl propertyMetadata : Arrays.asList(this, (PropertyMetadataImpl)this.entityMetadata.getPropertyMetadata(propertyName))) {
                    if (!propertyMetadata.hasColumns()) {
                        return false;
                    }
                    Iterator iterCol = propertyMetadata.property.getColumnIterator();
                    while (iterCol.hasNext()) {
                        Column column = (Column)iterCol.next();
                        keyMembers &= column != null && uniqueKey.containsColumn(column);
                    }
                    totcols += propertyMetadata.property.getColumnSpan();
                }
                if (!keyMembers || totcols != uniqueKey.getColumnSpan()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMemberOfUniqueKey() {
        if (!this.hasColumns()) {
            return false;
        }
        for (PersistentClass pc = this.entityMetadata.getPersistentClass(); pc != null; pc = pc.getSuperclass()) {
            Table table = pc.getTable();
            Iterator iterUK = table.getUniqueKeyIterator();
            while (iterUK.hasNext()) {
                UniqueKey uniqueKey = (UniqueKey)iterUK.next();
                boolean member = true;
                Iterator iterCol = this.property.getColumnIterator();
                while (iterCol.hasNext()) {
                    Column column = (Column)iterCol.next();
                    member &= column != null && uniqueKey.containsColumn(column);
                }
                if (!member) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isOfJavaType(Class<?> type) {
        return this.property.getType().getReturnedClass().isAssignableFrom(type);
    }

    public boolean isOneToManyType() {
        return this.property.getType() instanceof CollectionType;
    }

    public boolean isOneToOneType() {
        return this.property.getType() instanceof OneToOneType;
    }

    public boolean isNumericType() {
        return Number.class.isAssignableFrom(this.property.getType().getReturnedClass());
    }

    public boolean isOptional() {
        return this.property.isOptional() && !this.isMandatory();
    }

    protected boolean isMandatory() {
        Validator validator = (Validator)ContextUtil.getBean(Validator.class);
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(this.getEntityMetadata().getMappedClass());
        if (!beanDescriptor.isBeanConstrained()) {
            return false;
        }
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty(this.property.getName());
        if (propertyDescriptor == null) {
            return false;
        }
        Set constraints = propertyDescriptor.findConstraints().declaredOn(new ElementType[]{ElementType.FIELD}).unorderedAndMatchingGroups(new Class[]{Default.class}).getConstraintDescriptors();
        for (ConstraintDescriptor constraint : constraints) {
            if (!NotNull.class.isInstance(constraint.getAnnotation()) && !NotBlank.class.isInstance(constraint.getAnnotation()) && !NotEmpty.class.isInstance(constraint.getAnnotation())) continue;
            return true;
        }
        return false;
    }

    public boolean isTimestampType() {
        return this.property.getType() instanceof TimestampType;
    }

    public <E extends Entity> boolean isProxyValue(E entity) {
        if (!this.isIdentifier()) {
            Object value;
            if (entity instanceof HibernateProxy) {
                entity = ContextUtil.getMRS().deproxyEntity(entity);
            }
            return (value = this.entityMetadata.getClassMetadata().getPropertyValue(entity, this.getName())) != null && value instanceof HibernateProxy;
        }
        return false;
    }

    public boolean isUpdateable() {
        return !this.entityMetadata.isReadOnly() && this.property.isUpdateable() && !this.disableUserUpdate && !this.formula && !this.isIdentityIdentifier() && (PropertyGeneration.NEVER == this.property.getGeneration() || PropertyGeneration.INSERT == this.property.getGeneration());
    }

    public <E extends Entity> void setValue(E entity, Object value) {
        if (!this.identifier) {
            this.entityMetadata.getClassMetadata().setPropertyValue(entity, this.getName(), value);
        } else {
            PropertyAccessorFactory.forDirectFieldAccess(entity).setPropertyValue(this.getName(), value);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!PropertyMetadata.class.isInstance(obj)) {
            return false;
        }
        PropertyMetadata other = (PropertyMetadata)obj;
        return this.entityMetadata.equals(other.getEntityMetadata()) && this.getName().equals(other.getName());
    }

    public String getWidth() {
        return this.width;
    }

    public String getHeight() {
        return this.height;
    }
}

