/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.criterion.Subqueries;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.util.StringUtils;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.DataReaderService;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.EntityFactory;
import org.web4thejob.orm.EntityMetadata;
import org.web4thejob.orm.Path;
import org.web4thejob.orm.PathMetadata;
import org.web4thejob.orm.PropertyMetadata;
import org.web4thejob.orm.query.Condition;
import org.web4thejob.orm.query.Criterion;
import org.web4thejob.orm.query.OrderBy;
import org.web4thejob.orm.query.Query;
import org.web4thejob.orm.query.Subquery;

class DataReaderServiceImpl
implements DataReaderService {
    @Autowired
    private SessionFactory sessionFactory;

    DataReaderServiceImpl() {
    }

    public <E extends Entity> E findById(Class<E> entityType, Serializable id) {
        return (E)((Entity)this.sessionFactory.getCurrentSession().get(entityType, id));
    }

    public <E extends Entity> List<E> findByQuery(Query query) {
        Criteria criteria = this.toDetachedCriteria(query).getExecutableCriteria(this.sessionFactory.getCurrentSession()).setCacheable(query.isCached());
        criteria.setFlushMode(FlushMode.MANUAL);
        if (StringUtils.hasText((String)query.getCacheRegion())) {
            criteria.setCacheRegion(query.getCacheRegion());
        }
        return criteria.list();
    }

    public <E extends Entity> E findFirstByQuery(Query query) {
        Criteria criteria = this.toDetachedCriteria(query).getExecutableCriteria(this.sessionFactory.getCurrentSession()).setMaxResults(1).setCacheable(query.isCached());
        if (StringUtils.hasText((String)query.getCacheRegion())) {
            criteria.setCacheRegion(query.getCacheRegion());
        }
        criteria.setFlushMode(FlushMode.MANUAL);
        List list = criteria.list();
        if (list.size() > 0) {
            return (E)((Entity)list.get(0));
        }
        return null;
    }

    public <E extends Entity> E findUniqueByQuery(Query query) {
        Criteria criteria = this.toDetachedCriteria(query).getExecutableCriteria(this.sessionFactory.getCurrentSession()).setMaxResults(2).setCacheable(query.isCached());
        if (StringUtils.hasText((String)query.getCacheRegion())) {
            criteria.setCacheRegion(query.getCacheRegion());
        }
        criteria.setFlushMode(FlushMode.MANUAL);
        List list = criteria.list();
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return (E)((Entity)list.get(0));
        }
        throw new DataIntegrityViolationException("expecting unique result but got many");
    }

    public <E extends Entity> E get(Class<E> entityType, Serializable id) {
        return (E)((Entity)this.sessionFactory.getCurrentSession().get(entityType, id));
    }

    public <E extends Entity> List<E> getAll(Class<E> entityType) {
        return DetachedCriteria.forClass(entityType).getExecutableCriteria(this.sessionFactory.getCurrentSession()).setFlushMode(FlushMode.MANUAL).list();
    }

    public <E extends Entity> E getOne(Class<E> entityType) {
        return this.findFirstByQuery(((EntityFactory)ContextUtil.getBean(EntityFactory.class)).buildQuery(entityType));
    }

    public <E extends Entity> E refresh(E entity) {
        this.sessionFactory.getCurrentSession().refresh(entity);
        return entity;
    }

    public void evictCache() {
        if (this.sessionFactory.getCache() != null) {
            this.sessionFactory.getCache().evictCollectionRegions();
            this.sessionFactory.getCache().evictEntityRegions();
            this.sessionFactory.getCache().evictNaturalIdRegions();
            this.sessionFactory.getCache().evictQueryRegions();
        }
    }

    private DetachedCriteria toDetachedCriteria(Query query) {
        return this.toDetachedCriteria(query, "this");
    }

    private DetachedCriteria toDetachedCriteria(Query query, String alias) {
        boolean hasOneToManyAssociation = false;
        DetachedCriteria detachedCriteria = alias != null ? DetachedCriteria.forClass((Class)query.getTargetType(), (String)alias) : DetachedCriteria.forClass((Class)query.getTargetType());
        HashMap<String, String> aliases = new HashMap<String, String>();
        for (Criterion w4tjCriterion : query.getCriteria()) {
            org.hibernate.criterion.Criterion hibCriterion;
            if (w4tjCriterion.getCondition() == null || w4tjCriterion.getCondition().getOperandsNo() != 0 && (w4tjCriterion.getValue() == null || !StringUtils.hasText((String)w4tjCriterion.getValue().toString()))) continue;
            if (!hasOneToManyAssociation) {
                hasOneToManyAssociation = w4tjCriterion.getPropertyPath().hasOneToManySteps();
            }
            if (w4tjCriterion.isLocal()) {
                hibCriterion = this.toHibernateCriterion(w4tjCriterion, detachedCriteria.getAlias());
            } else {
                PropertyMetadata propertyMetadata;
                String aliasPath = null;
                Iterator i$ = w4tjCriterion.getPropertyPath().getSteps().iterator();
                while (i$.hasNext() && !(propertyMetadata = (PropertyMetadata)i$.next()).equals((Object)w4tjCriterion.getPropertyPath().getLastStep())) {
                    aliasPath = propertyMetadata.equals((Object)w4tjCriterion.getPropertyPath().getFirstStep()) ? propertyMetadata.getName() : aliasPath + "." + propertyMetadata.getName();
                    this.buildAlias(detachedCriteria, aliases, aliasPath);
                }
                hibCriterion = this.toHibernateCriterion(w4tjCriterion, (String)aliases.get(aliasPath));
            }
            detachedCriteria = detachedCriteria.add(hibCriterion);
        }
        if (!query.getSubqueries().isEmpty()) {
            String masterId = detachedCriteria.getAlias() + "." + ContextUtil.getMRS().getEntityMetadata(query.getTargetType()).getIdentifierName();
            int subqindex = 0;
            for (Subquery subquery : query.getSubqueries()) {
                detachedCriteria = detachedCriteria.add(this.toHibernateSubcriterion(masterId, String.valueOf(++subqindex), subquery));
            }
        }
        for (OrderBy orderBy : query.getOrderings()) {
            String property;
            PathMetadata pathMetadata = ContextUtil.getMRS().getPropertyPath(query.getTargetType(), StringUtils.delimitedListToStringArray((String)orderBy.getProperty(), (String)"/"));
            if (pathMetadata.isMultiStep()) {
                PropertyMetadata propertyMetadata;
                String aliasPath = null;
                if (!hasOneToManyAssociation) {
                    hasOneToManyAssociation = pathMetadata.hasOneToManySteps();
                }
                Iterator i$ = pathMetadata.getSteps().iterator();
                while (i$.hasNext() && !(propertyMetadata = (PropertyMetadata)i$.next()).equals((Object)pathMetadata.getLastStep())) {
                    aliasPath = propertyMetadata.equals((Object)pathMetadata.getFirstStep()) ? propertyMetadata.getName() : aliasPath + "." + propertyMetadata.getName();
                    this.buildAlias(detachedCriteria, aliases, aliasPath);
                }
                property = (String)aliases.get(aliasPath) + "." + pathMetadata.getLastStep().getName();
            } else {
                property = orderBy.getProperty();
            }
            if (orderBy.isDescending()) {
                detachedCriteria = detachedCriteria.addOrder(Order.desc((String)property));
                continue;
            }
            detachedCriteria = detachedCriteria.addOrder(Order.asc((String)property));
        }
        if (hasOneToManyAssociation) {
            detachedCriteria = detachedCriteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        }
        return detachedCriteria;
    }

    private String buildAlias(DetachedCriteria detachedCriteria, Map<String, String> aliases, String aliasPath) {
        if (!aliases.containsKey(aliasPath)) {
            String alias = aliasPath.replaceAll("\\.", "_");
            aliases.put(aliasPath, alias);
            detachedCriteria.createAlias(aliasPath, alias);
        }
        return aliases.get(aliasPath);
    }

    private org.hibernate.criterion.Criterion toHibernateCriterion(Criterion criterion, String alias) {
        SimpleExpression hibernate_criterion;
        String propertyName = criterion.getPropertyPath().getLastStep().getName();
        if (alias != null) {
            propertyName = alias + "." + propertyName;
        }
        if (criterion.getCondition().equals((Object)Condition.EQ)) {
            hibernate_criterion = Property.forName((String)propertyName).eq(criterion.getValue());
        } else if (criterion.getCondition().equals((Object)Condition.NE)) {
            hibernate_criterion = Property.forName((String)propertyName).ne(criterion.getValue());
        } else if (criterion.getCondition().equals((Object)Condition.GT)) {
            hibernate_criterion = Property.forName((String)propertyName).gt(criterion.getValue());
        } else if (criterion.getCondition().equals((Object)Condition.GTE)) {
            hibernate_criterion = Property.forName((String)propertyName).ge(criterion.getValue());
        } else if (criterion.getCondition().equals((Object)Condition.LT)) {
            hibernate_criterion = Property.forName((String)propertyName).lt(criterion.getValue());
        } else if (criterion.getCondition().equals((Object)Condition.LTE)) {
            hibernate_criterion = Property.forName((String)propertyName).le(criterion.getValue());
        } else if (criterion.getCondition().equals((Object)Condition.NL)) {
            hibernate_criterion = Property.forName((String)propertyName).isNull();
        } else if (criterion.getCondition().equals((Object)Condition.NNL)) {
            hibernate_criterion = Property.forName((String)propertyName).isNotNull();
        } else if (criterion.getCondition().equals((Object)Condition.SW)) {
            hibernate_criterion = Property.forName((String)propertyName).like(criterion.getValue().toString(), MatchMode.START);
        } else if (criterion.getCondition().equals((Object)Condition.NSW)) {
            hibernate_criterion = Restrictions.not((org.hibernate.criterion.Criterion)Property.forName((String)propertyName).like(criterion.getValue().toString(), MatchMode.START));
        } else if (criterion.getCondition().equals((Object)Condition.CN)) {
            hibernate_criterion = Property.forName((String)propertyName).like(criterion.getValue().toString(), MatchMode.ANYWHERE);
        } else if (criterion.getCondition().equals((Object)Condition.NCN)) {
            hibernate_criterion = Restrictions.not((org.hibernate.criterion.Criterion)Property.forName((String)propertyName).like(criterion.getValue().toString(), MatchMode.ANYWHERE));
        } else if (criterion.getCondition().equals((Object)Condition.EW)) {
            hibernate_criterion = Property.forName((String)propertyName).like(criterion.getValue().toString(), MatchMode.END);
        } else if (criterion.getCondition().equals((Object)Condition.NEW)) {
            hibernate_criterion = Restrictions.not((org.hibernate.criterion.Criterion)Property.forName((String)propertyName).like(criterion.getValue().toString(), MatchMode.END));
        } else if (criterion.getCondition().equals((Object)Condition.IN)) {
            hibernate_criterion = Restrictions.in((String)propertyName, (Collection)((Collection)criterion.getValue()));
        } else if (criterion.getCondition().equals((Object)Condition.NIN)) {
            hibernate_criterion = Restrictions.not((org.hibernate.criterion.Criterion)Restrictions.in((String)propertyName, (Collection)((Collection)criterion.getValue())));
        } else if (criterion.getCondition().equals((Object)Condition.EX) || criterion.getCondition().equals((Object)Condition.NEX)) {
            EntityMetadata target = criterion.getPropertyPath().getLastStep().getAssociatedEntityMetadata();
            Subquery subquery = criterion.getCondition().equals((Object)Condition.EX) ? new Subquery(Subquery.SubqueryType.TYPE_EXISTS, target) : new Subquery(Subquery.SubqueryType.TYPE_NOT_EXISTS, target);
            for (PropertyMetadata propertyMetadata : target.getPropertiesMetadata()) {
                if (!criterion.getPropertyPath().getLastStep().isAssociatedWith(propertyMetadata)) continue;
                subquery.addCriterion(ContextUtil.getMRS().getPropertyPath(target.getEntityType(), new Path(propertyMetadata.getName())), Condition.EQ, (Object)Subquery.MASTER_ID_PLACEHOLDER);
                break;
            }
            if (subquery.getCriteria().isEmpty()) {
                throw new RuntimeException("subquery failed: " + criterion.toString());
            }
            hibernate_criterion = this.toHibernateSubcriterion(alias + "." + criterion.getPropertyPath().getLastStep().getName(), alias, subquery);
        } else {
            throw new RuntimeException("unknown condition encountered: " + criterion.getCondition().toString());
        }
        return hibernate_criterion;
    }

    private org.hibernate.criterion.Criterion toHibernateSubcriterion(String masterId, String subqueryAlias, Subquery subquery) {
        String alias = "subq_" + subqueryAlias;
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass((Class)subquery.getTarget().getEntityType(), (String)alias);
        for (Criterion criterion : subquery.getCriteria()) {
            if (Subquery.MASTER_ID_PLACEHOLDER == criterion.getValue()) {
                String subProperty = alias + "." + criterion.getPropertyPath().getPath();
                detachedCriteria = detachedCriteria.add((org.hibernate.criterion.Criterion)Property.forName((String)subProperty).eqProperty(masterId));
                continue;
            }
            if (Property.class.isInstance(criterion.getValue())) {
                detachedCriteria = detachedCriteria.add((org.hibernate.criterion.Criterion)((Property)criterion.getValue()).eqProperty(masterId));
                continue;
            }
            detachedCriteria = detachedCriteria.add(this.toHibernateCriterion(criterion, alias));
        }
        if (subquery.getSubqueryType() == Subquery.SubqueryType.TYPE_EXISTS) {
            return Subqueries.exists((DetachedCriteria)detachedCriteria.setProjection((Projection)Projections.property((String)(alias + "." + subquery.getTarget().getIdentifierName()))));
        }
        return Subqueries.notExists((DetachedCriteria)detachedCriteria.setProjection((Projection)Projections.property((String)(alias + "." + subquery.getTarget().getIdentifierName()))));
    }
}

