/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import org.springframework.stereotype.Service;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.AuthorizationPolicyImpl;
import org.web4thejob.orm.CustomSessionFactoryBean;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.EntityFactory;
import org.web4thejob.orm.EntityMetadata;
import org.web4thejob.orm.PanelDefinition;
import org.web4thejob.orm.PanelDefinitionImpl;
import org.web4thejob.orm.PathMetadata;
import org.web4thejob.orm.QueryImpl;
import org.web4thejob.orm.RenderElementImpl;
import org.web4thejob.orm.RenderSchemeImpl;
import org.web4thejob.orm.RoleIdentityImpl;
import org.web4thejob.orm.RoleMembersImpl;
import org.web4thejob.orm.UserIdentityImpl;
import org.web4thejob.orm.parameter.Parameter;
import org.web4thejob.orm.query.Query;
import org.web4thejob.orm.scheme.RenderElement;
import org.web4thejob.orm.scheme.RenderScheme;
import org.web4thejob.security.AuthorizationPolicy;
import org.web4thejob.security.RoleIdentity;
import org.web4thejob.security.RoleMembers;
import org.web4thejob.security.UserIdentity;

@Service
class EntityFactoryImpl
implements EntityFactory {
    EntityFactoryImpl() {
    }

    public PanelDefinition buildPanelDefinition() {
        return new PanelDefinitionImpl();
    }

    public Query buildQuery(Class<? extends Entity> entityType) {
        return new QueryImpl(entityType);
    }

    public Query buildQuery(String entityName) {
        return new QueryImpl(this.toEntityType(entityName));
    }

    public <T extends Parameter> T buildParameter(Class<T> parameterType) {
        try {
            return (T)((Parameter)((CustomSessionFactoryBean)ContextUtil.getBean(CustomSessionFactoryBean.class)).getConfiguration().getClassMapping(parameterType.getCanonicalName()).getMappedClass().newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RenderScheme buildRenderScheme(Class<? extends Entity> entityType) {
        return new RenderSchemeImpl(entityType);
    }

    public RenderScheme buildRenderScheme(String entityName) {
        return new RenderSchemeImpl(this.toEntityType(entityName));
    }

    public RenderElement buildRenderElement(RenderScheme renderScheme) {
        RenderElementImpl renderElement = new RenderElementImpl();
        renderElement.setRenderScheme(renderScheme);
        return renderElement;
    }

    public RenderElement buildRenderElement(PathMetadata pathMetadata) {
        RenderElementImpl renderElement = new RenderElementImpl();
        renderElement.setPropertyPath(pathMetadata);
        return renderElement;
    }

    public UserIdentity buildUserIdentity() {
        return new UserIdentityImpl();
    }

    public RoleIdentity buildRoleIdentity() {
        return new RoleIdentityImpl();
    }

    public RoleMembers buildRoleMembers() {
        return new RoleMembersImpl();
    }

    public Class<? extends Entity> toEntityType(String entityName) {
        EntityMetadata entityMetadata = ContextUtil.getMRS().getEntityMetadata(entityName);
        if (entityMetadata != null) {
            return entityMetadata.getEntityType();
        }
        return null;
    }

    public AuthorizationPolicy buildAuthorizationPolicy() {
        return new AuthorizationPolicyImpl();
    }
}

