/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.EntityMetadata;
import org.web4thejob.orm.Path;
import org.web4thejob.orm.query.Condition;
import org.web4thejob.orm.query.Query;
import org.web4thejob.orm.scheme.RenderScheme;
import org.web4thejob.orm.scheme.RenderSchemeUtil;
import org.web4thejob.orm.scheme.SchemeType;
import org.web4thejob.security.Identity;
import org.web4thejob.security.RoleIdentity;
import org.web4thejob.security.RoleMembers;
import org.web4thejob.security.UserIdentity;
import org.web4thejob.util.CoreUtil;

class MappingInitializer
implements ApplicationListener<ContextRefreshedEvent> {
    MappingInitializer() {
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getParent() != null) {
            return;
        }
        ContextUtil.getMRS().refreshMetaCache();
        this.ensureAdministratorExists();
        if (ContextUtil.getMRS().getEntityMetadata(RenderScheme.class) != null) {
            this.createDefaultRenderSchemes(SchemeType.LIST_SCHEME);
            this.createDefaultRenderSchemes(SchemeType.ENTITY_SCHEME);
        }
    }

    private void createDefaultRenderSchemes(SchemeType schemeType) {
        for (EntityMetadata entityMetadata : ContextUtil.getMRS().getEntityMetadatas()) {
            RenderScheme renderScheme = RenderSchemeUtil.getDefaultRenderScheme((Class)entityMetadata.getEntityType(), (SchemeType)schemeType);
            if (renderScheme == null) {
                renderScheme = RenderSchemeUtil.createDefaultRenderScheme((Class)entityMetadata.getEntityType(), (SchemeType)schemeType);
                renderScheme.setOwner((Identity)ContextUtil.getSecurityService().getAdministratorIdentity());
                ContextUtil.getDWS().save((Entity)renderScheme);
            }
            CoreUtil.addSystemLock((Entity)renderScheme);
        }
    }

    private void ensureAdministratorExists() {
        UserIdentity userAdmin = ContextUtil.getSecurityService().getAdministratorIdentity();
        Query query = ContextUtil.getEntityFactory().buildQuery(RoleIdentity.class);
        query.addCriterion(new Path("code"), Condition.EQ, (Object)"ADMINISTRATOR");
        RoleIdentity roleAdmin = (RoleIdentity)ContextUtil.getDRS().findUniqueByQuery(query);
        if (roleAdmin == null) {
            roleAdmin = ContextUtil.getEntityFactory().buildRoleIdentity();
            roleAdmin.setCode("ADMINISTRATOR");
            ContextUtil.getDWS().save((Entity)roleAdmin);
        }
        query = ContextUtil.getEntityFactory().buildQuery(RoleMembers.class);
        query.addCriterion(new Path("role"), Condition.EQ, (Object)roleAdmin);
        query.addCriterion(new Path("user"), Condition.EQ, (Object)userAdmin);
        RoleMembers adminMembers = (RoleMembers)ContextUtil.getDRS().findUniqueByQuery(query);
        if (adminMembers == null) {
            adminMembers = ContextUtil.getEntityFactory().buildRoleMembers();
            adminMembers.setRole(roleAdmin);
            adminMembers.setUser(userAdmin);
            ContextUtil.getDWS().save((Entity)adminMembers);
        }
        CoreUtil.addSystemLock((Entity)userAdmin);
        CoreUtil.addSystemLock((Entity)roleAdmin);
        CoreUtil.addSystemLock((Entity)adminMembers);
    }
}

