/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.Type;
import org.springframework.util.StringUtils;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.EntityMetadata;
import org.web4thejob.orm.HibernateConfiguration;
import org.web4thejob.orm.MetaReaderServiceImpl;
import org.web4thejob.orm.MetaUtil;
import org.web4thejob.orm.PropertyMetadata;
import org.web4thejob.orm.PropertyMetadataImpl;
import org.web4thejob.orm.UniqueKeyConstraint;
import org.web4thejob.orm.UniqueKeyConstraintImpl;

class EntityMetadataImpl
implements EntityMetadata {
    private static final String META_FRIENDLY_NAME = "friendlyName";
    private static final String META_TABLE_SUBSET = "tableSubset";
    private static final String META_TABLE_CACHED = "cached";
    private static final String META_DENY_ADDNEW = "deny-add-new";
    private static final String META_DENY_UPDATE = "deny-update";
    private static final String META_DENY_DELETE = "deny-delete";
    private static final Logger logger = Logger.getLogger(EntityMetadataImpl.class);
    private final SortedSet<PropertyMetadata> propertySet = new TreeSet<PropertyMetadata>();
    private final HashMap<String, PropertyMetadata> propertyMap = new HashMap();
    private final String identifier;
    private final Type identifierType;
    private final Class<? extends Entity> entityType;
    private final ClassMetadata classMetadata;
    private final boolean versioned;
    private final PersistentClass persistentClass;
    private final String friendlyName;
    private final List<Class<? extends Entity>> subclasses;
    private final boolean tableSubset;
    private final boolean cached;
    private final boolean denyAddNew;
    private final boolean denyDelete;
    private final boolean denyUpdate;
    private List<UniqueKeyConstraint> uniqueKeyConstraints;

    public EntityMetadataImpl(ClassMetadata classMetadata) {
        boolean isAbstract;
        this.classMetadata = classMetadata;
        this.persistentClass = ((HibernateConfiguration)ContextUtil.getBean(HibernateConfiguration.class)).getConfiguration().getClassMapping(classMetadata.getEntityName());
        this.entityType = this.getEntityType(classMetadata.getEntityName());
        this.identifier = classMetadata.getIdentifierPropertyName();
        this.identifierType = classMetadata.getIdentifierType();
        this.versioned = classMetadata.getVersionProperty() >= 0;
        this.friendlyName = MetaUtil.hasMetaAttribute(this.persistentClass, META_FRIENDLY_NAME) ? MetaUtil.getMetaAttribute(this.persistentClass, META_FRIENDLY_NAME) : classMetadata.getEntityName();
        this.tableSubset = MetaUtil.hasMetaAttribute(this.persistentClass, META_TABLE_SUBSET) ? Boolean.parseBoolean(MetaUtil.getMetaAttribute(this.persistentClass, META_TABLE_SUBSET)) : false;
        this.cached = MetaUtil.hasMetaAttribute(this.persistentClass, META_TABLE_CACHED) ? Boolean.parseBoolean(MetaUtil.getMetaAttribute(this.persistentClass, META_TABLE_CACHED)) : false;
        boolean bl = isAbstract = this.persistentClass.isAbstract() != null ? this.persistentClass.isAbstract() : false;
        this.denyAddNew = MetaUtil.hasMetaAttribute(this.persistentClass, META_DENY_ADDNEW) ? isAbstract || Boolean.parseBoolean(MetaUtil.getMetaAttribute(this.persistentClass, META_DENY_ADDNEW)) : isAbstract;
        this.denyUpdate = MetaUtil.hasMetaAttribute(this.persistentClass, META_DENY_UPDATE) ? Boolean.parseBoolean(MetaUtil.getMetaAttribute(this.persistentClass, META_DENY_UPDATE)) : false;
        this.denyDelete = MetaUtil.hasMetaAttribute(this.persistentClass, META_DENY_DELETE) ? Boolean.parseBoolean(MetaUtil.getMetaAttribute(this.persistentClass, META_DENY_DELETE)) : false;
        PropertyMetadataImpl propertyMetadata = new PropertyMetadataImpl(this, classMetadata.getIdentifierPropertyName());
        this.propertySet.add(propertyMetadata);
        this.propertyMap.put(propertyMetadata.getName(), propertyMetadata);
        int i = 0;
        for (String propertyName : classMetadata.getPropertyNames()) {
            if (!(this.isBackref(propertyName) || this.isVersionProperty(i) || this.isDiscriminatorDuplicate(propertyName))) {
                propertyMetadata = new PropertyMetadataImpl(this, propertyName);
                this.propertySet.add(propertyMetadata);
                this.propertyMap.put(propertyMetadata.getName(), propertyMetadata);
            } else {
                logger.debug((Object)("ignoring property of " + classMetadata.getEntityName() + ": " + propertyName));
            }
            ++i;
        }
        if (this.persistentClass.hasSubclasses()) {
            this.subclasses = new ArrayList<Class<? extends Entity>>();
            Iterator iter = this.persistentClass.getSubclassIterator();
            while (iter.hasNext()) {
                Subclass subclass = (Subclass)iter.next();
                try {
                    this.subclasses.add(Class.forName(subclass.getEntityName()));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            this.subclasses = Collections.emptyList();
        }
    }

    private boolean isDiscriminatorDuplicate(String propertyName) {
        if (this.persistentClass instanceof RootClass) {
            return false;
        }
        if (this.persistentClass.getRootClass().getDiscriminator() == null) {
            return false;
        }
        if (this.persistentClass.getProperty(propertyName) == null) {
            return false;
        }
        if (!this.persistentClass.getProperty(propertyName).getColumnIterator().hasNext()) {
            return false;
        }
        Object dcolumn = this.persistentClass.getRootClass().getDiscriminator().getColumnIterator().next();
        Object pcolumn = this.persistentClass.getProperty(propertyName).getColumnIterator().next();
        if (dcolumn instanceof Column && pcolumn instanceof Column) {
            return ((Column)dcolumn).getName().equals(((Column)pcolumn).getName());
        }
        return false;
    }

    private Class<? extends Entity> getEntityType(String entityName) {
        try {
            return Class.forName(entityName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(entityName + " is not a valid Entity implementation");
        }
    }

    private boolean isBackref(String propertyName) {
        return propertyName.startsWith("_") && propertyName.toLowerCase().endsWith("backref");
    }

    private boolean isVersionProperty(int index) {
        return this.classMetadata.getVersionProperty() == index;
    }

    public ClassMetadata getClassMetadata() {
        return this.classMetadata;
    }

    public Class<? extends Entity> getEntityType() {
        return this.entityType;
    }

    public String getIdentifierName() {
        return this.identifier;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public String getSchema() {
        if (StringUtils.hasText((String)this.persistentClass.getTable().getSchema())) {
            return this.persistentClass.getTable().getSchema();
        }
        return ((HibernateConfiguration)ContextUtil.getBean(HibernateConfiguration.class)).getConfiguration().getProperty("hibernate.default_schema");
    }

    public String getName() {
        return this.classMetadata.getEntityName();
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public <E extends Entity> Integer getVersion(E entity) {
        return (Integer)this.classMetadata.getVersion(entity);
    }

    public SortedSet<PropertyMetadata> getPropertiesMetadata() {
        return this.propertySet;
    }

    public PropertyMetadata getPropertyMetadata(String property) {
        StringTokenizer tokenizer;
        PropertyMetadata propertyMetadata = this.propertyMap.get(property);
        if (propertyMetadata == null && (tokenizer = new StringTokenizer(property, "()", false)).hasMoreTokens()) {
            String type = tokenizer.nextToken();
            String name = tokenizer.nextToken();
            propertyMetadata = this.propertyMap.get(name);
            return propertyMetadata.castForSubclass(ContextUtil.getEntityFactory().toEntityType(type));
        }
        return propertyMetadata;
    }

    public Class<? extends Entity> getMappedClass() {
        return this.classMetadata.getMappedClass();
    }

    public boolean isReadOnly() {
        return !this.persistentClass.isMutable();
    }

    public <A extends Annotation> PropertyMetadata getAnnotatedProperty(Class<A> annotation) {
        for (PropertyMetadata propertyMetadata : this.getPropertiesMetadata()) {
            if (propertyMetadata.getAnnotation(annotation) == null) continue;
            return propertyMetadata;
        }
        return null;
    }

    public List<UniqueKeyConstraint> getUniqueConstraints() {
        return this.uniqueKeyConstraints;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!EntityMetadata.class.isInstance(obj)) {
            return false;
        }
        EntityMetadata other = (EntityMetadata)obj;
        return this.getName().equals(other.getName());
    }

    public boolean isCached() {
        return this.cached || this.persistentClass.getCacheConcurrencyStrategy() != null;
    }

    public boolean isTableSubset() {
        return this.tableSubset;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.classMetadata.getMappedClass().getModifiers());
    }

    public String toString() {
        return this.entityType.toString();
    }

    public boolean isDenyAddNew() {
        return this.denyAddNew;
    }

    public boolean isDenyDelete() {
        return this.denyDelete;
    }

    public boolean isDenyUpdate() {
        return this.denyUpdate;
    }

    public Object getVersionValue(Entity entity) {
        if (entity == null) {
            return null;
        }
        if (!this.versioned) {
            return null;
        }
        if (!entity.getEntityType().equals(this.getEntityType())) {
            return null;
        }
        return this.classMetadata.getPropertyValue((Object)entity, this.persistentClass.getVersion().getName());
    }

    public void setVersionValue(Entity entity, Object value) {
        if (entity == null) {
            return;
        }
        if (!this.versioned) {
            return;
        }
        if (!entity.getEntityType().equals(this.getEntityType())) {
            return;
        }
        this.classMetadata.setPropertyValue((Object)entity, this.persistentClass.getVersion().getName(), value);
    }

    public List<Class<? extends Entity>> getSubclasses() {
        return this.subclasses;
    }

    void initUniqueKeyConstraints() {
        this.uniqueKeyConstraints = new ArrayList<UniqueKeyConstraint>();
        for (PersistentClass pc = this.persistentClass; pc != null; pc = pc.getSuperclass()) {
            Iterator iter = pc.getTable().getUniqueKeyIterator();
            while (iter.hasNext()) {
                if (this.persistentClass.equals(pc)) {
                    this.uniqueKeyConstraints.add(new UniqueKeyConstraintImpl(this, (UniqueKey)iter.next()));
                    continue;
                }
                this.uniqueKeyConstraints.add(new UniqueKeyConstraintImpl(MetaReaderServiceImpl.metaCache.get(pc.getEntityName()), (UniqueKey)iter.next()));
            }
            if (RootClass.class.isInstance(pc)) continue;
            iter = pc.getJoinIterator();
            while (iter.hasNext()) {
                Join join = (Join)iter.next();
                Iterator iter2 = join.getTable().getUniqueKeyIterator();
                while (iter2.hasNext()) {
                    this.uniqueKeyConstraints.add(new UniqueKeyConstraintImpl(this, (UniqueKey)iter2.next()));
                }
            }
        }
        this.uniqueKeyConstraints = Collections.unmodifiableList(this.uniqueKeyConstraints);
    }

    public String getFullFriendlyName() {
        return "[" + this.getSchema() + "] " + this.getFriendlyName();
    }
}

