/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import org.hibernate.EntityNameResolver;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.PanelDefinition;
import org.web4thejob.orm.parameter.EntityTypeEntityViewParameter;
import org.web4thejob.orm.parameter.EntityTypeListViewParameter;
import org.web4thejob.orm.parameter.EntityTypeQueryParameter;
import org.web4thejob.orm.parameter.LocationImagesRepoParameter;
import org.web4thejob.orm.parameter.LocationParameter;
import org.web4thejob.orm.parameter.Parameter;
import org.web4thejob.orm.parameter.PrinterCharsetParameter;
import org.web4thejob.orm.query.Criterion;
import org.web4thejob.orm.query.OrderBy;
import org.web4thejob.orm.query.Query;
import org.web4thejob.orm.scheme.RenderElement;
import org.web4thejob.orm.scheme.RenderScheme;
import org.web4thejob.security.AuthorizationPolicy;
import org.web4thejob.security.Identity;
import org.web4thejob.security.RoleIdentity;
import org.web4thejob.security.RoleMembers;
import org.web4thejob.security.UserIdentity;

public class EntityNameResolverImpl
implements EntityNameResolver {
    public static final EntityNameResolverImpl INSTANCE = new EntityNameResolverImpl();

    public boolean equals(Object obj) {
        return this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String resolveEntityName(Object entity) {
        Class<Entity> entityType = this.resolveEntityType((Entity)entity);
        if (entityType != null) {
            return entityType.getName();
        }
        return null;
    }

    public <E extends Entity> Class<? extends Entity> resolveEntityType(E entity) {
        if (entity instanceof Query) {
            return Query.class;
        }
        if (entity instanceof Criterion) {
            return Criterion.class;
        }
        if (entity instanceof OrderBy) {
            return OrderBy.class;
        }
        if (entity instanceof RenderScheme) {
            return RenderScheme.class;
        }
        if (entity instanceof RenderElement) {
            return RenderElement.class;
        }
        if (entity instanceof PanelDefinition) {
            return PanelDefinition.class;
        }
        if (entity instanceof RoleMembers) {
            return RoleMembers.class;
        }
        if (entity instanceof AuthorizationPolicy) {
            return AuthorizationPolicy.class;
        }
        if (entity instanceof EntityTypeEntityViewParameter) {
            return EntityTypeEntityViewParameter.class;
        }
        if (entity instanceof EntityTypeListViewParameter) {
            return EntityTypeListViewParameter.class;
        }
        if (entity instanceof EntityTypeQueryParameter) {
            return EntityTypeQueryParameter.class;
        }
        if (entity instanceof PrinterCharsetParameter) {
            return PrinterCharsetParameter.class;
        }
        if (entity instanceof LocationImagesRepoParameter) {
            return LocationImagesRepoParameter.class;
        }
        if (entity instanceof LocationParameter) {
            return LocationParameter.class;
        }
        if (entity instanceof Parameter) {
            return Parameter.class;
        }
        if (entity instanceof UserIdentity) {
            return UserIdentity.class;
        }
        if (entity instanceof RoleIdentity) {
            return RoleIdentity.class;
        }
        if (entity instanceof Identity) {
            return Identity.class;
        }
        return null;
    }
}

