/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.EntityMetadata;
import org.web4thejob.orm.Path;
import org.web4thejob.orm.PathMetadata;
import org.web4thejob.orm.PropertyMetadata;

class PathMetadataImpl
implements PathMetadata {
    private final List<PropertyMetadata> steps;
    private final String path;

    public PathMetadataImpl(Class<? extends Entity> entityType, Path nodes) {
        this(entityType, StringUtils.delimitedListToStringArray((String)nodes.toString(), (String)"/"));
    }

    public PathMetadataImpl(Class<? extends Entity> entityType, String[] path) {
        this.path = StringUtils.arrayToDelimitedString((Object[])path, (String)"/");
        this.steps = new ArrayList<PropertyMetadata>();
        EntityMetadata entityMetadata = ContextUtil.getMRS().getEntityMetadata(entityType);
        if (entityMetadata == null) {
            throw new IllegalArgumentException("Entity type " + entityType.getName() + " is unknown");
        }
        for (String step : path) {
            PropertyMetadata propertyMetadata = entityMetadata.getPropertyMetadata(step);
            if (propertyMetadata == null) {
                throw new RuntimeException("invalid attribute " + step + " for entity type " + entityMetadata.getName());
            }
            this.steps.add(propertyMetadata);
            entityMetadata = propertyMetadata.getAssociatedEntityMetadata();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!PathMetadata.class.isInstance(obj)) {
            return false;
        }
        PathMetadata other = (PathMetadata)obj;
        return this.getRoot().equals((Object)other.getRoot()) && this.getPath().equals(other.getPath());
    }

    public PropertyMetadata getFirstStep() {
        return this.steps.get(0);
    }

    public PropertyMetadata getLastStep() {
        return this.steps.get(this.steps.size() - 1);
    }

    public String getPath() {
        return this.path;
    }

    public EntityMetadata getRoot() {
        return this.getFirstStep().getEntityMetadata();
    }

    public List<PropertyMetadata> getSteps() {
        return this.steps;
    }

    public <T, E extends Entity> T getValue(E rootEntity) {
        Object value = rootEntity;
        for (PropertyMetadata step : this.steps) {
            if (!step.getEntityMetadata().getEntityType().isInstance(value)) {
                return null;
            }
            if ((value = step.getValue(value)) != null) continue;
            return null;
        }
        return (T)value;
    }

    public int hashCode() {
        if (this.getRoot() == null || this.getPath() == null) {
            return super.hashCode();
        }
        int prime = 31;
        int result = this.getRoot().hashCode();
        result = 31 * result + this.getPath().hashCode();
        return result;
    }

    public boolean isMultiStep() {
        return this.steps.size() > 1;
    }

    public boolean hasOneToManySteps() {
        for (PropertyMetadata step : this.steps) {
            if (!step.isOneToManyType()) continue;
            return true;
        }
        return false;
    }

    public String getFriendlyName() {
        StringBuilder sb = new StringBuilder();
        for (PropertyMetadata step : this.steps) {
            if (sb.length() > 0) {
                sb.append(" > ");
            }
            sb.append(step.getFriendlyName());
        }
        return sb.toString();
    }

    public String toString() {
        return this.path;
    }
}

