/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.UniqueKey;
import org.springframework.util.StringUtils;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.EntityMetadata;
import org.web4thejob.orm.HibernateConfiguration;
import org.web4thejob.orm.Path;
import org.web4thejob.orm.PropertyMetadata;
import org.web4thejob.orm.UniqueKeyConstraint;
import org.web4thejob.orm.query.Condition;
import org.web4thejob.orm.query.Query;

public class UniqueKeyConstraintImpl
implements UniqueKeyConstraint {
    private final EntityMetadata entityMetadata;
    private final Set<PropertyMetadata> propertyMetadatas;

    public UniqueKeyConstraintImpl(EntityMetadata entityMetadata, UniqueKey uniqueKey) {
        this.entityMetadata = entityMetadata;
        HashSet<PropertyMetadata> temp = new HashSet<PropertyMetadata>();
        Iterator iterCols = uniqueKey.getColumnIterator();
        while (iterCols.hasNext()) {
            Column column = (Column)iterCols.next();
            PropertyMetadata propertyMetadata = this.getPropertyForColumn(column);
            if (propertyMetadata == null) continue;
            temp.add(propertyMetadata);
        }
        this.propertyMetadatas = Collections.unmodifiableSet(temp);
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    public Set<PropertyMetadata> getPropertyMetadatas() {
        return this.propertyMetadatas;
    }

    public String getFriendlyName() {
        StringBuilder stringBuffer = new StringBuilder();
        for (PropertyMetadata propertyMetadata : this.propertyMetadatas) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(propertyMetadata.getFriendlyName());
        }
        return stringBuffer.toString();
    }

    public Query getValidationQuery(Entity entity) {
        Query query = ContextUtil.getEntityFactory().buildQuery(this.entityMetadata.getEntityType());
        for (PropertyMetadata propertyMetadata : this.getPropertyMetadatas()) {
            query.addCriterion(new Path(propertyMetadata), Condition.EQ, propertyMetadata.getValue(entity));
        }
        return query;
    }

    public boolean isViolated(Entity entity) {
        boolean notNull = true;
        for (PropertyMetadata propertyMetadata : this.getPropertyMetadatas()) {
            Object val = propertyMetadata.getValue(entity);
            notNull &= val != null && StringUtils.hasText((String)val.toString());
        }
        if (notNull) {
            return !ContextUtil.getDRS().findByQuery(this.getValidationQuery(entity)).isEmpty();
        }
        return false;
    }

    public PropertyMetadata getPropertyForColumn(Column column) {
        for (PersistentClass pc = ((HibernateConfiguration)ContextUtil.getBean(HibernateConfiguration.class)).getConfiguration().getClassMapping(this.entityMetadata.getName()); pc != null; pc = pc.getSuperclass()) {
            Iterator iterProps = pc.getPropertyIterator();
            while (iterProps.hasNext()) {
                Property property = (Property)iterProps.next();
                Iterator iterCols = property.getColumnIterator();
                while (iterCols.hasNext()) {
                    Column col = (Column)iterCols.next();
                    if (!col.equals(column)) continue;
                    return this.entityMetadata.getPropertyMetadata(property.getName());
                }
            }
        }
        return null;
    }
}

