/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.module;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.Target;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.module.Joblet;
import org.web4thejob.module.JobletInstaller;

@Component
class JobletInstallerImpl
implements JobletInstaller {
    private Properties connInfo;

    JobletInstallerImpl() {
    }

    public Properties getConnectionInfo() {
        return this.connInfo;
    }

    public void setConnectionInfo(Properties connInfo) {
        this.connInfo = connInfo;
    }

    public boolean canConnect() {
        try {
            Class.forName(this.connInfo.getProperty("datasource.driverClassName"));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        try {
            Connection conn = DriverManager.getConnection(this.connInfo.getProperty("datasource.url"), this.connInfo.getProperty("datasource.username"), this.connInfo.getProperty("datasource.password"));
            conn.close();
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public <E extends Exception> List<E> installAll() {
        ArrayList<Joblet> joblets = new ArrayList<Joblet>();
        joblets.add(ContextUtil.getSystemJoblet());
        joblets.addAll(ContextUtil.getJoblets());
        return this.install(joblets);
    }

    public <E extends Exception> List<E> install(List<Joblet> joblets) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        try {
            Configuration configuration = new Configuration();
            configuration.setProperty("hibernate.dialect", this.connInfo.getProperty("datasource.dialect"));
            configuration.setProperty("hibernate.connection.driver_class", this.connInfo.getProperty("datasource.driverClassName"));
            configuration.setProperty("hibernate.connection.url", this.connInfo.getProperty("datasource.url"));
            configuration.setProperty("hibernate.connection.username", this.connInfo.getProperty("datasource.username"));
            configuration.setProperty("hibernate.connection.password", this.connInfo.getProperty("datasource.password"));
            StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).build();
            if (StringUtils.hasText((String)this.connInfo.getProperty("datasource.schema_syntax"))) {
                String schemaSyntax = this.connInfo.getProperty("datasource.schema_syntax");
                Connection connection = ((ConnectionProvider)serviceRegistry.getService(ConnectionProvider.class)).getConnection();
                for (Joblet joblet : joblets) {
                    for (String schema : joblet.getSchemas()) {
                        Statement statement = connection.createStatement();
                        statement.executeUpdate(schemaSyntax.replace("%s", schema));
                        statement.close();
                    }
                }
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            for (Joblet joblet : joblets) {
                for (Resource resource : joblet.getResources()) {
                    configuration.addInputStream(resource.getInputStream());
                }
            }
            SchemaExport schemaExport = new SchemaExport((ServiceRegistry)serviceRegistry, configuration);
            schemaExport.execute(Target.EXPORT, SchemaExport.Type.CREATE);
            exceptions.addAll(schemaExport.getExceptions());
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        return exceptions;
    }
}

