/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.util.ReflectionUtils;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.EntityNameResolverImpl;
import org.web4thejob.orm.validation.ValidatingGroup;
import org.web4thejob.web.panel.DirtyListener;

public abstract class AbstractHibernateEntity
implements Entity {
    private static final EntityNameResolverImpl entityNameResolver = EntityNameResolverImpl.INSTANCE;
    private DirtyListener dirtyListener;
    private Map<String, Object> attributes;

    protected void setDirty() {
        this.calculate();
        if (this.dirtyListener != null) {
            this.dirtyListener.onDirty(true);
        }
    }

    public void addDirtyListener(DirtyListener dirtyListener) {
        this.dirtyListener = dirtyListener;
    }

    public Entity clone() {
        try {
            final Entity clone = (Entity)ReflectHelper.getDefaultConstructor(this.getClass()).newInstance(null);
            clone.addDirtyListener(this.dirtyListener);
            ReflectionUtils.doWithFields(this.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                    ReflectionUtils.makeAccessible((Field)field);
                    if (!Collection.class.isAssignableFrom(field.getType())) {
                        field.set(clone, field.get(AbstractHibernateEntity.this));
                    }
                }
            }, (ReflectionUtils.FieldFilter)ReflectionUtils.COPYABLE_FIELDS);
            return clone;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Clone failed for " + this.toString(), e);
        }
    }

    public void merge(final Entity source) {
        ReflectionUtils.doWithFields(this.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                ReflectionUtils.makeAccessible((Field)field);
                if (!Collection.class.isAssignableFrom(field.getType())) {
                    field.set(AbstractHibernateEntity.this, field.get(source));
                }
            }
        }, (ReflectionUtils.FieldFilter)ReflectionUtils.COPYABLE_FIELDS);
    }

    public Class<? extends Entity> getEntityType() {
        Class<Entity> entityType = entityNameResolver.resolveEntityType(this);
        if (entityType != null) {
            return entityType;
        }
        if (this instanceof HibernateProxy) {
            return ((HibernateProxy)this).getHibernateLazyInitializer().getPersistentClass();
        }
        return this.getClass();
    }

    public boolean isNewInstance() {
        Serializable id = this.getIdentifierValue();
        return id == null || id.toString().equals("0") || id.toString().equals("");
    }

    public String toRichString() {
        return this.toString();
    }

    public Set<ConstraintViolation<Entity>> validate() {
        Class[] groups;
        this.calculate();
        Validator validator = (Validator)ContextUtil.getBean(Validator.class);
        Set violations = validator.validate((Object)this, new Class[0]);
        if (this instanceof ValidatingGroup && (groups = ((ValidatingGroup)this).getGroupNames()) != null) {
            violations.addAll(validator.validate((Object)this, groups));
        }
        return violations;
    }

    public <T> void setAttribute(String key, T value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(1);
            this.attributes.put(key, value);
        }
    }

    public <T> T getAttribute(String key) {
        if (this.attributes != null) {
            return (T)this.attributes.get(key);
        }
        return null;
    }

    public void removeAttribute(String key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    public boolean hasAttribute(String key) {
        return this.attributes != null && this.attributes.containsKey(key);
    }

    public void calculate() {
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getEntityType()).append((Object)this.getIdentifierValue()).toHashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!Entity.class.isInstance(o)) {
            return false;
        }
        return new EqualsBuilder().append(this.getEntityType(), (Object)((Entity)o).getEntityType()).append((Object)this.getIdentifierValue(), (Object)((Entity)o).getIdentifierValue()).isEquals();
    }
}

