/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.orm.hibernate4.HibernateObjectRetrievalFailureException;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.StringUtils;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.AbstractHibernateEntity;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.PathMetadata;
import org.web4thejob.orm.query.Condition;
import org.web4thejob.orm.query.Criterion;
import org.web4thejob.orm.query.Query;

class CriterionImpl
extends AbstractHibernateEntity
implements Criterion {
    private Condition condition;
    private long id;
    private int index;
    @NotNull
    private Query query;
    @NotBlank
    private String flatPropertyPath;
    private String flatValue;
    private boolean fixed;
    private PathMetadata propertyPath;
    private Object value;
    private final boolean master;

    public CriterionImpl(boolean isMaster) {
        this.master = isMaster;
    }

    public CriterionImpl() {
        this(false);
    }

    private Object deserializeValue(String flatValue) {
        Unmarshaller unmarshaller = (Unmarshaller)ContextUtil.getBean(Unmarshaller.class);
        try {
            List list;
            Object value = unmarshaller.unmarshal((Source)new StreamSource(new ByteArrayInputStream(flatValue.getBytes("UTF-8"))));
            if (value instanceof Entity) {
                try {
                    value = ContextUtil.getDRS().refresh((Entity)value);
                }
                catch (HibernateObjectRetrievalFailureException e) {
                    return null;
                }
            } else if (value instanceof List && !(list = (List)value).isEmpty() && list.get(0) instanceof Entity) {
                for (Object item : list) {
                    try {
                        ContextUtil.getDRS().refresh((Entity)item);
                    }
                    catch (HibernateObjectRetrievalFailureException e) {
                        return list.remove(item);
                    }
                }
            }
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String serializeValue(Object value) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Marshaller marshaller = (Marshaller)ContextUtil.getBean(Marshaller.class);
        StreamResult result = new StreamResult(out);
        try {
            marshaller.marshal(value, (Result)result);
            return out.toString("UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Condition getCondition() {
        return this.condition;
    }

    public String getFlatCondition() {
        if (this.condition != null) {
            return this.condition.getKey();
        }
        return null;
    }

    public String getFlatPropertyPath() {
        if (this.flatPropertyPath == null && this.propertyPath != null) {
            this.flatPropertyPath = this.propertyPath.getPath();
        }
        return this.flatPropertyPath;
    }

    public String getFlatValue() {
        if (this.flatValue == null && this.value != null) {
            this.flatValue = this.serializeValue(this.value);
        }
        return this.flatValue;
    }

    public long getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public PathMetadata getPropertyPath() {
        if (this.propertyPath == null && this.flatPropertyPath != null) {
            if (this.getQuery() == null) {
                throw new IllegalStateException("query cannot be null.");
            }
            this.propertyPath = ContextUtil.getMRS().getPropertyPath(this.query.getTargetType(), StringUtils.delimitedListToStringArray((String)this.flatPropertyPath, (String)"/"));
        }
        return this.propertyPath;
    }

    public Query getQuery() {
        return this.query;
    }

    public Object getValue() {
        if (this.getPropertyPath() == null) {
            throw new IllegalStateException("property path cannot be null.");
        }
        if (this.value == null && this.flatValue != null) {
            this.value = this.deserializeValue(this.flatValue);
        }
        return this.value;
    }

    public boolean isLocal() {
        return this.propertyPath == null || !this.propertyPath.isMultiStep();
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void setFlatCondition(String flatCondition) {
        this.condition = Condition.fromKey((String)flatCondition);
    }

    public void setFlatPropertyPath(String flatPropertyPath) {
        this.flatPropertyPath = flatPropertyPath;
        this.propertyPath = null;
    }

    public void setFlatValue(String flatValue) {
        this.flatValue = flatValue;
        this.value = null;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setIndex(int ordering) {
        this.index = ordering;
    }

    public void setPropertyPath(PathMetadata pathMetadata) {
        this.propertyPath = pathMetadata;
        this.flatPropertyPath = null;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void setValue(Object value) {
        this.value = value;
        this.flatValue = null;
    }

    public Serializable getIdentifierValue() {
        return Long.valueOf(this.id);
    }

    public void setAsNew() {
        this.id = 0L;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public boolean isMaster() {
        return this.master;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getFlatPropertyPath() != null) {
            sb.append(this.getFlatPropertyPath());
        } else {
            sb.append("null");
        }
        sb.append(" ");
        if (this.getFlatCondition() != null) {
            sb.append(this.getFlatCondition());
        } else {
            sb.append("null");
        }
        sb.append(" ");
        if (this.getFlatValue() != null) {
            sb.append(this.getFlatValue());
        } else {
            sb.append("null");
        }
        return sb.toString();
    }
}

