/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.metadata.ClassMetadata;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.HibernateConfiguration;

class MetaUtil {
    MetaUtil() {
    }

    public static int getHibernatePropertyIndex(String entityType, String propertyName) {
        SessionFactory sessionFactory = (SessionFactory)ContextUtil.getBean(SessionFactory.class);
        ClassMetadata classMetadata = sessionFactory.getClassMetadata(entityType);
        for (int i = 0; i < classMetadata.getPropertyNames().length; ++i) {
            if (!classMetadata.getPropertyNames()[i].equals(propertyName)) continue;
            return i;
        }
        return -1;
    }

    public static String getMetaAttribute(Property property, String name) {
        return property.getMetaAttribute(name).getValue();
    }

    public static String getMetaAttribute(PersistentClass persistentClass, String name) {
        return persistentClass.getMetaAttribute(name).getValue();
    }

    public static boolean hasMetaAttribute(Property property, String name) {
        MetaAttribute metaAttribute = property.getMetaAttribute(name);
        if (metaAttribute != null) {
            try {
                return metaAttribute.getValue() != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean hasMetaAttribute(PersistentClass persistentClass, String name) {
        MetaAttribute metaAttribute = persistentClass.getMetaAttribute(name);
        if (metaAttribute != null) {
            try {
                return metaAttribute.getValue() != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isIdentityKey(KeyValue key) {
        return key.isIdentityColumn((IdentifierGeneratorFactory)((HibernateConfiguration)ContextUtil.getBean(HibernateConfiguration.class)).getConfiguration().getIdentifierGeneratorFactory(), ((SessionFactoryImplementor)ContextUtil.getBean(SessionFactoryImplementor.class)).getDialect());
    }
}

