/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.validator.constraints.NotBlank;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.AbstractHibernateEntity;
import org.web4thejob.orm.CriterionImpl;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.EntityFactory;
import org.web4thejob.orm.OrderByImpl;
import org.web4thejob.orm.Path;
import org.web4thejob.orm.annotation.UserIdHolder;
import org.web4thejob.orm.query.Condition;
import org.web4thejob.orm.query.Criterion;
import org.web4thejob.orm.query.OrderBy;
import org.web4thejob.orm.query.Query;
import org.web4thejob.orm.query.Subquery;
import org.web4thejob.security.Identity;

class QueryImpl
extends AbstractHibernateEntity
implements Query {
    private long id;
    @NotBlank
    private String name;
    @NotBlank
    private String flatTargetType;
    private int version;
    private Class<? extends Entity> targetType;
    private List<Criterion> criteria = new ArrayList<Criterion>(0);
    private List<OrderBy> orderings = new ArrayList<OrderBy>(0);
    private List<Subquery> subqueries;
    private boolean cached;
    @UserIdHolder
    private Identity owner;
    private String cacheRegion;

    public String getCacheRegion() {
        return this.cacheRegion;
    }

    public void setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
    }

    public QueryImpl() {
    }

    public QueryImpl(Class<? extends Entity> targetType) {
        this.targetType = targetType;
    }

    public List<Criterion> getCriteria() {
        return this.criteria;
    }

    public void setCriteria(List<Criterion> criteria) {
        this.criteria = criteria;
    }

    public String getFlatTargetType() {
        if (this.flatTargetType == null && this.targetType != null) {
            this.flatTargetType = this.targetType.getName();
        }
        return this.flatTargetType;
    }

    public List<Subquery> getSubqueries() {
        if (this.subqueries == null) {
            return Collections.emptyList();
        }
        return this.subqueries;
    }

    public void setSubqueries(List<Subquery> subqueries) {
        this.subqueries = subqueries;
    }

    public boolean hasMasterCriterion() {
        for (Criterion criterion : this.criteria) {
            if (!criterion.isMaster()) continue;
            return true;
        }
        return false;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<OrderBy> getOrderings() {
        return this.orderings;
    }

    public void setOrderings(List<OrderBy> orderings) {
        this.orderings = orderings;
    }

    public Class<? extends Entity> getTargetType() {
        if (this.targetType == null && this.flatTargetType != null) {
            this.targetType = ((EntityFactory)ContextUtil.getBean(EntityFactory.class)).toEntityType(this.flatTargetType);
        }
        return this.targetType;
    }

    public String toString() {
        return this.name;
    }

    public Serializable getIdentifierValue() {
        return Long.valueOf(this.id);
    }

    public void setAsNew() {
        this.id = 0L;
    }

    public Criterion addCriterion(Path property, Condition condition) {
        return this.addCriterion(property, condition, null, false, false);
    }

    public Criterion addCriterion(Path property, Condition condition, Object value) {
        return this.addCriterion(property, condition, value, false, false);
    }

    public Criterion addCriterion(Path property, Condition condition, Object value, boolean isFixed) {
        return this.addCriterion(property, condition, value, isFixed, false);
    }

    public Criterion addCriterion(Path property, Condition condition, Object value, boolean isFixed, boolean isMaster) {
        CriterionImpl criterion = new CriterionImpl(isMaster);
        criterion.setQuery(this);
        criterion.setPropertyPath(ContextUtil.getMRS().getPropertyPath(this.getTargetType(), property));
        criterion.setCondition(condition);
        criterion.setValue(value);
        criterion.setFixed(isFixed);
        this.criteria.add(criterion);
        return criterion;
    }

    public Criterion addCriterion(Criterion criterion) {
        CriterionImpl criterionImpl = (CriterionImpl)criterion.clone();
        criterionImpl.setQuery(this);
        this.criteria.add(criterionImpl);
        return criterionImpl;
    }

    public OrderBy addOrderBy(Path property) {
        return this.addOrderBy(property, false, false);
    }

    public OrderBy addOrderBy(Path property, boolean descending) {
        return this.addOrderBy(property, descending, false);
    }

    public OrderBy addOrderBy(Path property, boolean descending, boolean isFixed) {
        OrderByImpl orderBy = new OrderByImpl();
        orderBy.setQuery(this);
        orderBy.setProperty(property.toString());
        orderBy.setDescending(descending);
        orderBy.setFixed(isFixed);
        this.orderings.add(orderBy);
        return orderBy;
    }

    public OrderBy addOrderBy(OrderBy orderBy) {
        OrderByImpl orderByImpl = (OrderByImpl)orderBy.clone();
        orderByImpl.setQuery(this);
        this.orderings.add(orderByImpl);
        return orderByImpl;
    }

    public void setFlatTargetType(String flatTargetType) {
        this.flatTargetType = flatTargetType;
        this.targetType = null;
    }

    public void setTargetType(Class<? extends Entity> targetType) {
        this.targetType = targetType;
        this.flatTargetType = null;
    }

    public Identity getOwner() {
        return this.owner;
    }

    public void setOwner(Identity owner) {
        this.owner = owner;
    }
}

