/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.util.StringUtils;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.AbstractHibernateEntity;
import org.web4thejob.orm.PathMetadata;
import org.web4thejob.orm.scheme.RenderElement;
import org.web4thejob.orm.scheme.RenderScheme;

class RenderElementImpl
extends AbstractHibernateEntity
implements RenderElement {
    private long id;
    @NotNull
    private RenderScheme renderScheme;
    @NotBlank
    private String friendlyName;
    @NotBlank
    private String flatPropertyPath;
    private String style;
    private String format;
    private String align;
    private int colSpan = 1;
    private int index;
    private String width;
    private String height;
    private PathMetadata propertyPath;
    private String propertyViewer;
    private String propertyEditor;
    private boolean readOnly;

    RenderElementImpl() {
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    public String getFlatPropertyPath() {
        if (this.flatPropertyPath == null && this.propertyPath != null) {
            this.flatPropertyPath = this.propertyPath.getPath();
        }
        return this.flatPropertyPath;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public PathMetadata getPropertyPath() {
        if (this.propertyPath == null && this.flatPropertyPath != null) {
            if (this.getRenderScheme() == null) {
                throw new IllegalStateException("renderScheme cannot be null.");
            }
            this.propertyPath = ContextUtil.getMRS().getPropertyPath(this.getRenderScheme().getTargetType(), StringUtils.delimitedListToStringArray((String)this.flatPropertyPath, (String)"/"));
        }
        return this.propertyPath;
    }

    public RenderScheme getRenderScheme() {
        return this.renderScheme;
    }

    public void setRenderScheme(RenderScheme renderScheme) {
        this.renderScheme = renderScheme;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String toString() {
        return this.flatPropertyPath;
    }

    public Serializable getIdentifierValue() {
        return Long.valueOf(this.id);
    }

    public void setAsNew() {
        this.id = 0L;
    }

    public void setPropertyPath(PathMetadata propertyPath) {
        this.propertyPath = propertyPath;
        this.flatPropertyPath = null;
    }

    public void setFlatPropertyPath(String flatPropertyPath) {
        this.flatPropertyPath = flatPropertyPath;
        this.propertyPath = null;
    }

    public String getPropertyViewer() {
        return this.propertyViewer;
    }

    public void setPropertyViewer(String propertyViewer) {
        this.propertyViewer = propertyViewer;
    }

    public String getPropertyEditor() {
        return this.propertyEditor;
    }

    public void setPropertyEditor(String propertyEditor) {
        this.propertyEditor = propertyEditor;
    }
}

