/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.AbstractHibernateEntity;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.EntityFactory;
import org.web4thejob.orm.PathMetadata;
import org.web4thejob.orm.PropertyMetadata;
import org.web4thejob.orm.RenderElementImpl;
import org.web4thejob.orm.annotation.UserIdHolder;
import org.web4thejob.orm.scheme.RenderElement;
import org.web4thejob.orm.scheme.RenderScheme;
import org.web4thejob.orm.scheme.SchemeType;
import org.web4thejob.security.Identity;
import org.web4thejob.util.CoreUtil;
import org.web4thejob.util.L10nMessages;

class RenderSchemeImpl
extends AbstractHibernateEntity
implements RenderScheme {
    private long id;
    @NotBlank
    private String name;
    @NotBlank
    private String friendlyName;
    @NotBlank
    private String flatTargetType;
    @NotNull
    private Locale locale;
    @NotNull
    private SchemeType schemeType;
    @Range(min=1L, max=3L)
    private int colSpan = 1;
    private int index = Integer.MAX_VALUE;
    private List<RenderElement> elements = new ArrayList<RenderElement>();
    @UserIdHolder
    private Identity owner;
    private Integer pageSize;
    private Class<? extends Entity> targetType;
    private int version;

    public RenderSchemeImpl() {
    }

    public RenderSchemeImpl(Class<? extends Entity> targetType) {
        this.targetType = targetType;
    }

    public RenderElement addElement(PathMetadata propertyPath) {
        RenderElementImpl element = new RenderElementImpl();
        element.setRenderScheme(this);
        element.setPropertyPath(propertyPath);
        element.setFormat(propertyPath.getLastStep().getFormat());
        element.setStyle(propertyPath.getLastStep().getStyle());
        element.setAlign(propertyPath.getLastStep().getAlign());
        element.setWidth(propertyPath.getLastStep().getWidth());
        element.setHeight(propertyPath.getLastStep().getHeight());
        if (CoreUtil.getUserLocale().equals(Locale.getDefault())) {
            element.setFriendlyName(propertyPath.getFriendlyName());
        } else {
            element.setFriendlyName(propertyPath.getPath());
        }
        this.elements.add(element);
        return element;
    }

    public RenderElement addElement(PropertyMetadata propertyMetadata) {
        return this.addElement(ContextUtil.getMRS().getPropertyPath(propertyMetadata));
    }

    public RenderElement addElement(RenderElement renderElement) {
        RenderElementImpl element = (RenderElementImpl)renderElement.clone();
        element.setRenderScheme(this);
        this.elements.add(element);
        return element;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public List<RenderElement> getElements() {
        return this.elements;
    }

    public long getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getName() {
        return this.name;
    }

    public SchemeType getSchemeType() {
        return this.schemeType;
    }

    public Class<? extends Entity> getTargetType() {
        if (this.targetType == null && this.flatTargetType != null) {
            this.targetType = ((EntityFactory)ContextUtil.getBean(EntityFactory.class)).toEntityType(this.flatTargetType);
        }
        return this.targetType;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    public void setElements(List<RenderElement> elements) {
        this.elements = elements;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSchemeType(SchemeType schemeType) {
        this.schemeType = schemeType;
    }

    public void setTargetType(Class<? extends Entity> targetType) {
        this.targetType = targetType;
        this.flatTargetType = null;
    }

    public Serializable getIdentifierValue() {
        return Long.valueOf(this.id);
    }

    public void setAsNew() {
        this.id = 0L;
    }

    public String getFlatTargetType() {
        if (this.flatTargetType == null && this.targetType != null) {
            this.flatTargetType = this.targetType.getName();
        }
        return this.flatTargetType;
    }

    public void setFlatTargetType(String flatTargetType) {
        this.flatTargetType = flatTargetType;
        this.targetType = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(" [");
        if (this.schemeType == SchemeType.LIST_SCHEME) {
            sb.append(L10nMessages.L10N_SCHEME_LIST.toString());
        } else if (this.schemeType == SchemeType.ENTITY_SCHEME) {
            sb.append(L10nMessages.L10N_SCHEME_ENTITY.toString());
        }
        sb.append(", ");
        sb.append(this.locale);
        sb.append("]");
        return sb.toString();
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer size) {
        this.pageSize = size;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public Identity getOwner() {
        return this.owner;
    }

    public void setOwner(Identity owner) {
        this.owner = owner;
    }
}

