/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.orm.serial;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Calendar;
import java.util.Date;
import org.web4thejob.orm.serial.DateFormula;

public class DateFormulaConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        throw new UnsupportedOperationException();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String value = reader.getValue();
        if (value.startsWith("@date00")) {
            Calendar cal = Calendar.getInstance();
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(9, 0);
            if (value.contains("+")) {
                int days = Integer.parseInt(value.split("\\+")[1]);
                cal.add(5, days);
            } else if (value.contains("-")) {
                int days = Integer.parseInt(value.split("\\-")[1]);
                cal.add(5, -days);
            }
            return cal.getTime();
        }
        if (value.startsWith("@date")) {
            Date date = Calendar.getInstance().getTime();
            if (value.contains("+")) {
                int days = Integer.parseInt(value.split("\\+")[1]);
                Calendar cal = Calendar.getInstance();
                cal.add(5, days);
                date = cal.getTime();
            } else if (value.contains("-")) {
                int days = Integer.parseInt(value.split("\\-")[1]);
                Calendar cal = Calendar.getInstance();
                cal.add(5, -days);
                date = cal.getTime();
            }
            return date;
        }
        return null;
    }

    public boolean canConvert(Class type) {
        return DateFormula.class.isAssignableFrom(type);
    }
}

