/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.security;

import com.sun.jndi.ldap.LdapCtxFactory;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class ADAuthenticationProvider
implements AuthenticationProvider {
    private String url;
    private String pattern;
    private UserDetailsService userDetailsService;

    public ADAuthenticationProvider(String url, String pattern, UserDetailsService userDetailsService) {
        this.url = url;
        this.pattern = pattern;
        this.userDetailsService = userDetailsService;
    }

    private String getPrincipal(String uname) {
        MessageFormat mf = new MessageFormat(this.pattern);
        return mf.format(new String[]{uname});
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication.getName() == null || (String)authentication.getCredentials() == null) {
            throw new BadCredentialsException("");
        }
        String principal = this.getPrincipal(authentication.getName());
        String passwd = (String)authentication.getCredentials();
        Context ctx = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", LdapCtxFactory.class.getCanonicalName());
            env.put("java.naming.security.authentication", "Simple");
            env.put("java.naming.security.principal", principal);
            env.put("java.naming.security.credentials", passwd);
            env.put("java.naming.provider.url", this.url);
            ctx = new InitialLdapContext(env, null);
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(principal);
            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)"", userDetails.getAuthorities());
            return usernamePasswordAuthenticationToken;
        }
        catch (NamingException nex) {
            throw new BadCredentialsException("LDAP authentication failed.", (Throwable)nex);
        }
        catch (UsernameNotFoundException e) {
            throw new BadCredentialsException("UserDetails did not find a valid user for name: " + principal, (Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

